/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb.builder.schema.reader;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.droitateddb.builder.schema.data.ColumnValidation;
import org.droitateddb.builder.schema.data.ValidatorInfo;
import org.droitateddb.builder.schema.reader.Reader;
import org.droitateddb.builder.schema.visitor.ColumnDeclaredTypeRetrievalVisitor;
import org.droitateddb.builder.schema.visitor.DefaultTypeVisitor;
import org.droitateddb.builder.schema.visitor.ValidatorAllowedTypeRetrievalVisitor;
import org.droitateddb.validation.Validator;

public class ColumnValidationReader
implements Reader<ColumnValidation> {
    public static final String VALIDATOR_VALUE_METHOD_NAME = "value";
    private VariableElement column;
    private Elements elements;
    private final Messager messager;

    public ColumnValidationReader(VariableElement column, Elements elements, Messager messager) {
        this.column = column;
        this.elements = elements;
        this.messager = messager;
    }

    @Override
    public ColumnValidation read() {
        ColumnValidation columnValidation = new ColumnValidation();
        List<? extends AnnotationMirror> annotationMirrors = this.column.getAnnotationMirrors();
        for (AnnotationMirror annotationMirror : annotationMirrors) {
            Element element = annotationMirror.getAnnotationType().asElement();
            for (AnnotationMirror annotationMirror2 : element.getAnnotationMirrors()) {
                if (!this.isValidatorAnnotation(annotationMirror2)) continue;
                String validatorClass = this.getValidatorClass(annotationMirror2, element);
                String validatorAnnotation = element.toString();
                Map<String, Object> parameter = this.getValidationParameter(annotationMirror);
                if (this.isParameterTypesValid(parameter)) {
                    columnValidation.add(new ValidatorInfo(validatorClass, validatorAnnotation, parameter));
                    continue;
                }
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Validator annotation " + validatorAnnotation + " has invalid parameters types. Allowed are numbers (primitive and boxed) and String", element);
            }
        }
        return columnValidation;
    }

    private boolean isParameterTypesValid(Map<String, Object> parameter) {
        for (Object paramValue : parameter.values()) {
            if (this.isValid(paramValue)) continue;
            return false;
        }
        return true;
    }

    private boolean isValid(Object value) {
        Class<?> paramType = value.getClass();
        return paramType.equals(String.class) || paramType.equals(Integer.class) || paramType.equals(Float.class) || paramType.equals(Double.class) || paramType.equals(Long.class) || paramType.equals(Short.class) || paramType.equals(Byte.class);
    }

    private boolean isValidatorAnnotation(AnnotationMirror mirror) {
        return mirror.getAnnotationType().asElement().toString().equals(Validator.class.getCanonicalName());
    }

    private String getValidatorClass(AnnotationMirror mirror, Element element) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = mirror.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
            if (!entry.getKey().getSimpleName().toString().equals(VALIDATOR_VALUE_METHOD_NAME)) continue;
            AnnotationValue value = entry.getValue();
            TypeElement acceptedType = value.accept(new ValidatorAllowedTypeRetrievalVisitor(this.column, this.messager), null);
            TypeElement actualType = this.column.accept(new ColumnDeclaredTypeRetrievalVisitor(), null);
            TypeKind columnTypeKind = this.column.asType().getKind();
            if (columnTypeKind.isPrimitive() && this.compareTypeWithPrimitive(acceptedType, columnTypeKind)) {
                return value.getValue().toString();
            }
            if (!columnTypeKind.isPrimitive() && this.compareTypeWithDeclared(acceptedType, actualType)) {
                return value.getValue().toString();
            }
            this.messager.printMessage(Diagnostic.Kind.ERROR, "The validator annotation " + element.toString() + " is not allowed on this type of column. Accepted is " + acceptedType.toString(), this.column);
            return null;
        }
        this.messager.printMessage(Diagnostic.Kind.ERROR, "No value set for Validator annotation", mirror.getAnnotationType().asElement());
        return null;
    }

    private boolean compareTypeWithPrimitive(TypeElement acceptedType, TypeKind columnTypeKind) {
        return acceptedType.getQualifiedName().toString().equals(this.getBoxedClassName(columnTypeKind)) || acceptedType.getQualifiedName().toString().equals(Number.class.getCanonicalName());
    }

    private boolean compareTypeWithDeclared(TypeElement acceptedType, TypeElement actualType) {
        if (acceptedType.getQualifiedName().equals(actualType.getQualifiedName())) {
            return true;
        }
        TypeMirror superclass = actualType.getSuperclass();
        if (superclass.getKind().equals((Object)TypeKind.NONE)) {
            return false;
        }
        TypeElement superTypeElement = superclass.accept(new DefaultTypeVisitor<TypeElement, Void>(){

            @Override
            public TypeElement visitDeclared(DeclaredType t, Void aVoid) {
                return (TypeElement)t.asElement();
            }
        }, null);
        return this.compareTypeWithDeclared(acceptedType, superTypeElement);
    }

    private String getBoxedClassName(TypeKind kind) {
        switch (kind) {
            case LONG: {
                return Long.class.getCanonicalName();
            }
            case INT: {
                return Integer.class.getCanonicalName();
            }
            case BYTE: {
                return Byte.class.getCanonicalName();
            }
            case SHORT: {
                return Short.class.getCanonicalName();
            }
            case FLOAT: {
                return Float.class.getCanonicalName();
            }
            case DOUBLE: {
                return Double.class.getCanonicalName();
            }
        }
        return "Unknown";
    }

    private Map<String, Object> getValidationParameter(AnnotationMirror mirror) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = this.elements.getElementValuesWithDefaults(mirror);
        HashMap<String, Object> parameter = new HashMap<String, Object>();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> elem : elementValues.entrySet()) {
            parameter.put(elem.getKey().getSimpleName().toString(), elem.getValue().getValue());
        }
        return parameter;
    }
}

