/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb.builder.schema.reader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import org.droitateddb.builder.schema.data.Association;
import org.droitateddb.builder.schema.data.Column;
import org.droitateddb.builder.schema.data.Table;
import org.droitateddb.builder.schema.reader.AssociationReader;
import org.droitateddb.builder.schema.reader.ColumnReader;
import org.droitateddb.builder.schema.reader.Reader;
import org.droitateddb.builder.schema.visitor.AssociationElementResolvingTypeVisitor;
import org.droitateddb.builder.schema.visitor.ColumnElementResolvingTypeVisitor;
import org.droitateddb.builder.schema.visitor.EmptyContructorVisitor;
import org.droitateddb.entity.PrimaryKey;
import org.droitateddb.entity.Relationship;
import org.droitateddb.schema.AssociationType;

public class TableReader
implements Reader<Table> {
    private final TypeElement entity;
    private final Set<String> entityNames;
    private final Elements elements;
    private final Messager messager;

    public TableReader(TypeElement entity, Set<String> entityNames, Elements elements, Messager messager) {
        this.entity = entity;
        this.entityNames = entityNames;
        this.elements = elements;
        this.messager = messager;
    }

    @Override
    public Table read() {
        int primaryKeyCount = 0;
        boolean noArgsConstructor = false;
        Table table = new Table(this.entity.getSimpleName().toString(), this.entity.toString());
        HashMap<String, AtomicInteger> countedToManyAssociations = new HashMap<String, AtomicInteger>();
        for (Element element : this.entity.getEnclosedElements()) {
            AssociationReader associationReader;
            Association read;
            VariableElement association;
            VariableElement column;
            if (element.accept(new EmptyContructorVisitor(), null) != null) {
                noArgsConstructor = true;
            }
            if ((column = element.accept(new ColumnElementResolvingTypeVisitor(), null)) != null) {
                if (this.hasAmbiguosAssociationDeclaration(column)) {
                    return null;
                }
                if (column.getAnnotation(PrimaryKey.class) != null && ++primaryKeyCount > 1) {
                    this.messager.printMessage(Diagnostic.Kind.ERROR, "Only one @PrimaryKey is allowed within an @Entity", this.entity);
                    return null;
                }
                ColumnReader columnReader = new ColumnReader(column, this.elements, this.messager);
                Column read2 = columnReader.read();
                if (read2 != null) {
                    table.addColumn(read2);
                }
            }
            if ((association = element.accept(new AssociationElementResolvingTypeVisitor(), null)) == null || (read = (associationReader = new AssociationReader(association, this.entityNames, this.messager)).read()) == null) continue;
            table.addAssociation(read);
            if (AssociationType.TO_MANY != read.getCardinality()) continue;
            if (countedToManyAssociations.containsKey(read.getCanonicalTypeInEntity())) {
                ((AtomicInteger)countedToManyAssociations.get(read.getCanonicalTypeInEntity())).incrementAndGet();
                continue;
            }
            countedToManyAssociations.put(read.getCanonicalTypeInEntity(), new AtomicInteger(1));
        }
        if (primaryKeyCount == 0) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "No @PrimaryKey was set for this @Entity", this.entity);
            return null;
        }
        if (!noArgsConstructor) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "An @Entity needs to have a no-args constructor", this.entity);
            return null;
        }
        List<String> multipeToManyAssocitionsInEntity = this.getMultipeToManyAssociations(countedToManyAssociations);
        if (multipeToManyAssocitionsInEntity.size() > 0) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "You can not have multipe To-Many associations of the same type within one @Entity at this moment. Conflicts are with Top-Many associtions of type  " + this.join(multipeToManyAssocitionsInEntity, ", "), this.entity);
        }
        return table;
    }

    private boolean hasAmbiguosAssociationDeclaration(VariableElement variableElement) {
        if (variableElement.getAnnotation(Relationship.class) != null) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Only @Column or @Relationship is allowed, but not both", variableElement);
            return true;
        }
        return false;
    }

    private List<String> getMultipeToManyAssociations(Map<String, AtomicInteger> countedToManyAssociations) {
        ArrayList<String> multipe = new ArrayList<String>();
        for (Map.Entry<String, AtomicInteger> entry : countedToManyAssociations.entrySet()) {
            if (entry.getValue().get() <= 1) continue;
            multipe.add(entry.getKey());
        }
        return multipe;
    }

    private String join(Collection<String> stringCollection, String separator) {
        StringBuilder builder = new StringBuilder();
        int count = 0;
        int size = stringCollection.size();
        for (String entry : stringCollection) {
            builder.append(entry);
            if (count++ >= size - 1) continue;
            builder.append(separator);
        }
        return builder.toString();
    }
}

