/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb.builder.schema.writer;

import java.util.Set;
import org.droitateddb.builder.schema.data.Column;
import org.droitateddb.builder.schema.data.Table;
import org.droitateddb.builder.schema.writer.Writer;

public class EntityInfoWriter
implements Writer {
    private final String indent;
    private final Table table;

    public EntityInfoWriter(String indent, Table table) {
        this.indent = indent;
        this.table = table;
    }

    @Override
    public String write() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.indent).append("public static final ").append("EntityInfo ").append(this.table.getName()).append("Info").append(" = new EntityInfo(\"").append(this.table.getEntityClassName()).append("\", ").append("\"").append(this.table.getName()).append("\", ").append(this.table.getName()).append("Table").append(".class, ").append(this.hasValidation()).append(");").append("\n");
        return builder.toString();
    }

    private boolean hasValidation() {
        Set<Column> columns = this.table.getColumns();
        for (Column column : columns) {
            if (column.getColumnValidation().size() <= 0) continue;
            return true;
        }
        return false;
    }
}

