/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb.builder.schema.writer;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.droitateddb.builder.schema.data.Association;
import org.droitateddb.builder.schema.data.Column;
import org.droitateddb.builder.schema.data.Table;
import org.droitateddb.builder.schema.writer.AssociationsInterfaceWriter;
import org.droitateddb.builder.schema.writer.ColumnWriter;
import org.droitateddb.builder.schema.writer.ToOneAssociationAttributeWriter;
import org.droitateddb.builder.schema.writer.Writer;
import org.droitateddb.schema.AssociationType;

public class TableWriter
implements Writer {
    private final String indent;
    private final Table table;

    public TableWriter(String indent, Table table) {
        this.indent = indent;
        this.table = table;
    }

    @Override
    public String write() {
        StringBuilder builder = new StringBuilder(this.indent);
        LinkedList<String> columnNames = new LinkedList<String>();
        LinkedList<String> toOneAssociationNames = new LinkedList<String>();
        LinkedList<String> columnSql = new LinkedList<String>();
        this.addDeclaration(builder);
        this.addTableData(builder);
        this.addColumns(builder, columnSql, columnNames, toOneAssociationNames);
        this.addSqlStatement(builder, columnSql);
        this.addProjection(builder, columnNames, toOneAssociationNames);
        this.addAttributes(builder, columnNames);
        this.addAssociations(builder);
        this.addEnd(builder);
        return builder.toString();
    }

    private void addDeclaration(StringBuilder builder) {
        builder.append("public interface ").append(this.table.getName()).append("Table").append(" {\n");
    }

    private void addTableData(StringBuilder builder) {
        builder.append(this.indent).append("    ").append(String.format("public static final String %s = \"%s\";\n", "CLASS_NAME", this.table.getEntityClassName()));
        builder.append(this.indent).append("    ").append(String.format("public static final String %s = \"%s\";\n", "TABLE_NAME", this.table.getName()));
        builder.append("\n");
    }

    private void addColumns(StringBuilder builder, List<String> columnSql, List<String> columnNames, List<String> toOneAssociationNames) {
        int columnIdx = 0;
        for (Column column : this.table.getColumns()) {
            ColumnWriter columnWriter = new ColumnWriter("    ", column, columnIdx++);
            builder.append(columnWriter.write());
            columnSql.add(columnWriter.getSql());
            columnNames.add(column.getNameInEntity());
        }
        for (Association association : this.table.getAssociations()) {
            if (association.getCardinality() != AssociationType.TO_ONE) continue;
            ToOneAssociationAttributeWriter toOneAssociationWriter = new ToOneAssociationAttributeWriter("    ", association, columnIdx++);
            builder.append(toOneAssociationWriter.write());
            columnSql.add(toOneAssociationWriter.getSql());
            toOneAssociationNames.add("fk_" + association.getNameInEntity());
        }
        builder.append("\n");
    }

    private void addSqlStatement(StringBuilder builder, List<String> columnSql) {
        StringBuilder statement = new StringBuilder("CREATE TABLE ");
        statement.append(this.table.getName()).append(" (");
        statement.append(this.concat(columnSql, new None()));
        statement.append(")");
        builder.append(this.indent).append("    ").append(String.format("public static final String %s = \"%s\";\n", "SQL_CREATION", statement.toString()));
        for (String column : this.filterIndexableColumns()) {
            StringBuilder index = new StringBuilder("CREATE INDEX ");
            index.append(this.table.getName().toLowerCase()).append("_").append(column.toLowerCase()).append("_idx");
            index.append(" on ").append(this.table.getName()).append(" (");
            index.append(column);
            index.append(")");
            builder.append(this.indent).append("    ").append(String.format("public static final String %s = \"%s\";\n", "SQL_INDEX_" + column.toUpperCase(), index.toString()));
        }
    }

    private void addProjection(StringBuilder builder, List<String> columnNames, List<String> toOneAssociationNames) {
        LinkedList<String> columnsWithForeignKeys = new LinkedList<String>(columnNames);
        columnsWithForeignKeys.addAll(toOneAssociationNames);
        builder.append(this.indent).append("    ").append(String.format("public static final String[] %s = new String[]{%s};\n", "PROJECTION", this.concat(columnsWithForeignKeys, new Quote())));
    }

    private void addAttributes(StringBuilder builder, List<String> columnNames) {
        builder.append(this.indent).append("    ").append(String.format("public static final AbstractAttribute[] %s = new AbstractAttribute[]{%s};\n", "ATTRIBUTES", this.concat(columnNames, new UpperCase())));
        builder.append("\n");
    }

    private void addAssociations(StringBuilder builder) {
        if (this.table.getAssociations().size() > 0) {
            builder.append(this.indent).append("    ").append("public interface ").append("Associations").append(" {\n");
            for (Association association : this.table.getAssociations()) {
                AssociationsInterfaceWriter associationWriter = new AssociationsInterfaceWriter(this.indent + "    " + "    ", this.table, association);
                builder.append(associationWriter.write());
            }
            builder.append(this.indent).append("    ").append("}\n");
        }
    }

    private void addEnd(StringBuilder builder) {
        builder.append(this.indent).append("}\n");
    }

    private Collection<String> filterIndexableColumns() {
        ArrayList<String> indexable = new ArrayList<String>();
        for (Column column : this.table.getColumns()) {
            if (!column.isPrimary()) continue;
            indexable.add(column.getNameInEntity());
        }
        for (Association association : this.table.getAssociations()) {
            if (AssociationType.TO_ONE != association.getCardinality()) continue;
            indexable.add("fk_" + association.getNameInEntity());
        }
        return indexable;
    }

    private String concat(Collection<String> columns, StringRefine refiner) {
        StringBuilder namesConcat = new StringBuilder();
        int counter = 0;
        for (String name : columns) {
            namesConcat.append(refiner.refine(name));
            if (counter++ >= columns.size() - 1) continue;
            namesConcat.append(", ");
        }
        return namesConcat.toString();
    }

    private final class None
    implements StringRefine {
        private None() {
        }

        @Override
        public String refine(String input) {
            return input;
        }
    }

    public class UpperCase
    implements StringRefine {
        @Override
        public String refine(String input) {
            return input.toUpperCase(Locale.getDefault());
        }
    }

    private final class Quote
    implements StringRefine {
        private Quote() {
        }

        @Override
        public String refine(String input) {
            return "\"" + input + "\"";
        }
    }

    private static interface StringRefine {
        public String refine(String var1);
    }
}

