/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb.builder.schema.writer;

import java.util.Locale;
import org.droitateddb.builder.schema.writer.Writer;
import org.droitateddb.util.Pair;

public class ToManyAssociationWriter
implements Writer {
    private final String indent;
    private final String tableName;
    private final String simpleLeft;
    private final String simpleLeftLower;
    private final String canonicalLeft;
    private final String simpleRight;
    private final String simpleRightLower;
    private final String canonicalRight;

    public ToManyAssociationWriter(String indent, Pair<String, String> link) {
        this.indent = indent;
        this.canonicalLeft = link.getFirst();
        this.simpleLeft = this.getSimpleName(this.canonicalLeft);
        this.simpleLeftLower = this.simpleLeft.toLowerCase(Locale.getDefault());
        this.canonicalRight = link.getSecond();
        this.simpleRight = this.getSimpleName(this.canonicalRight);
        this.simpleRightLower = this.simpleRight.toLowerCase(Locale.getDefault());
        this.tableName = this.simpleLeft + this.simpleRight + "Association";
    }

    @Override
    public String write() {
        StringBuilder builder = new StringBuilder();
        this.addDefinition(builder);
        this.addTableName(builder);
        this.addAttribute(builder, this.canonicalLeft, this.simpleLeftLower, 0, "_from");
        this.addAttribute(builder, this.canonicalRight, this.simpleRightLower, 1, "_to");
        builder.append("\n");
        this.addSqlStatement(builder);
        this.addProjection(builder);
        this.addAttributes(builder);
        this.addEnd(builder);
        return builder.toString();
    }

    private void addDefinition(StringBuilder builder) {
        builder.append(this.indent).append("public interface ").append(this.simpleLeft).append(this.simpleRight).append("Association").append(" {\n");
    }

    private void addTableName(StringBuilder builder) {
        builder.append(this.indent).append("    ").append(String.format("public static final String %s = \"%s\";\n", "TABLE_NAME", this.tableName));
        builder.append("\n");
    }

    private void addAttribute(StringBuilder builder, String canonicalName, String simpleName, int idx, String suffix) {
        String fkToUpper = ("fk_" + simpleName + suffix).toUpperCase(Locale.getDefault());
        builder.append(this.indent).append("    ").append("public static final ").append("IntegerAttribute ").append(fkToUpper).append(" = ").append("new IntegerAttribute(").append("\"").append("\", \"").append("fk_" + simpleName + suffix).append("\", ").append(canonicalName).append(".class, ").append(idx).append(");\n");
    }

    private void addSqlStatement(StringBuilder builder) {
        String fromColumn = "fk_" + this.simpleLeftLower + "_from";
        String toColumn = "fk_" + this.simpleRightLower + "_to";
        StringBuilder statement = new StringBuilder("CREATE TABLE ");
        statement.append(this.tableName).append("(");
        statement.append(fromColumn).append(" Integer, ");
        statement.append(toColumn).append(" Integer, ");
        statement.append("UNIQUE(").append(fromColumn).append(", ").append(toColumn).append(") ON CONFLICT IGNORE)");
        builder.append(this.indent).append("    ").append(String.format("public static final String %s = \"%s\";\n", "SQL_CREATION", statement.toString()));
        builder.append(this.indent).append("    ").append(this.createIndexStatement(this.tableName, fromColumn));
        builder.append(this.indent).append("    ").append(this.createIndexStatement(this.tableName, toColumn));
    }

    private String createIndexStatement(String tableName, String columnName) {
        String lowerColumnName = columnName.toLowerCase();
        StringBuilder index = new StringBuilder("CREATE INDEX ");
        index.append(tableName.toLowerCase()).append("_").append(lowerColumnName).append("_idx");
        index.append(" on ").append(tableName).append(" (");
        index.append(columnName);
        index.append(")");
        return String.format("public static final String %s = \"%s\";\n", "SQL_INDEX_" + lowerColumnName, index.toString());
    }

    private void addProjection(StringBuilder builder) {
        StringBuilder projection = new StringBuilder();
        projection.append("\"").append("fk_").append(this.simpleLeftLower + "_from").append("\", ").append("\"").append("fk_").append(this.simpleRightLower + "_to").append("\"");
        builder.append(this.indent).append("    ").append(String.format("public static final String[] %s = new String[]{%s};\n", "PROJECTION", projection.toString()));
    }

    private void addAttributes(StringBuilder builder) {
        StringBuilder concat = new StringBuilder();
        concat.append(("fk_" + this.simpleLeft + "_from").toUpperCase(Locale.getDefault())).append(", ").append(("fk_" + this.simpleRight + "_to").toUpperCase(Locale.getDefault()));
        builder.append(this.indent).append("    ").append(String.format("public static final AbstractAttribute[] %s = new AbstractAttribute[]{%s};\n", "ATTRIBUTES", concat.toString()));
    }

    private void addEnd(StringBuilder builder) {
        builder.append(this.indent).append("}\n");
    }

    private String getSimpleName(String canonical) {
        int lastDot = canonical.lastIndexOf(".");
        return canonical.substring(lastDot + 1, canonical.length());
    }
}

