/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb.cursor;

import android.content.Context;
import android.database.Cursor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.droitateddb.DbCreator;
import org.droitateddb.Utilities;
import org.droitateddb.cursor.CombinedCursor;
import org.droitateddb.cursor.ObjectCursor;
import org.droitateddb.cursor.ProxyableCursor;
import org.droitateddb.cursor.ReflectionUtil;
import org.droitateddb.schema.AbstractAttribute;
import org.droitateddb.schema.EntityInfo;

public class CombinedCursorImpl<T>
extends ProxyableCursor
implements CombinedCursor<T> {
    private final AbstractAttribute[] attributes;
    private final Class<T> entityClass;
    private final Cursor originalCursor;
    private AtomicBoolean closed = new AtomicBoolean(false);

    private CombinedCursorImpl(Cursor originalCursor, Class<T> entityClass, AbstractAttribute[] attributes) {
        this.originalCursor = originalCursor;
        this.entityClass = entityClass;
        this.attributes = attributes;
    }

    public static final <C> CombinedCursor<C> create(Context context, final Cursor originalCursor, EntityInfo entityInfo, Class<C> entityClass) {
        try {
            Class<?> definition = entityInfo.definition();
            AbstractAttribute[] attributes = (AbstractAttribute[])Utilities.getStaticFieldValue(definition, "ATTRIBUTES");
            final Context appContext = context.getApplicationContext();
            final CombinedCursorImpl<C> magicCursor = new CombinedCursorImpl<C>(originalCursor, entityClass, attributes);
            InvocationHandler handler = new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Class[] argTypes = args == null ? new Class[]{} : ReflectionUtil.getArgTypes(args);
                    try {
                        if (ReflectionUtil.isCloseMethod(method)) {
                            method.invoke((Object)originalCursor, args);
                            if (magicCursor.closed.compareAndSet(false, true)) {
                                DbCreator.getInstance(appContext).reduceDatabaseConnection();
                            }
                            return null;
                        }
                        if (ReflectionUtil.isMethodOfType(method, argTypes, Cursor.class)) {
                            return method.invoke((Object)originalCursor, args);
                        }
                        if (ReflectionUtil.isMethodOfType(method, argTypes, ObjectCursor.class)) {
                            return method.invoke((Object)magicCursor, args);
                        }
                        throw new UnsupportedOperationException("Unexpected method call for " + method.toString());
                    }
                    catch (InvocationTargetException ite) {
                        throw ite.getTargetException();
                    }
                }
            };
            return (CombinedCursor)Proxy.newProxyInstance(CombinedCursorImpl.class.getClassLoader(), new Class[]{CombinedCursor.class}, handler);
        }
        catch (Exception e) {
            throw Utilities.handle(e);
        }
    }

    private void assertEmptyCursor() {
        if (this.originalCursor.getCount() == 0) {
            throw new NoSuchElementException();
        }
    }

    private T construct() {
        try {
            Constructor<T> constructor = this.entityClass.getConstructor(new Class[0]);
            T instance = constructor.newInstance(new Object[0]);
            for (AbstractAttribute attribute : this.attributes) {
                Field field = Utilities.getDeclaredField(this.entityClass, attribute.fieldName());
                field.setAccessible(true);
                field.set(instance, attribute.getValueFromCursor(this.originalCursor));
            }
            return instance;
        }
        catch (Exception e) {
            throw Utilities.handle(e);
        }
    }

    @Override
    public Collection<T> getAll() {
        this.moveBeforeFirst();
        ArrayList<T> instances = new ArrayList<T>(this.originalCursor.getCount());
        while (this.originalCursor.moveToNext()) {
            instances.add(this.construct());
        }
        return instances;
    }

    private void moveBeforeFirst() {
        this.originalCursor.moveToFirst();
        this.originalCursor.moveToPrevious();
    }

    @Override
    public T getCurrent() {
        this.assertEmptyCursor();
        if (this.originalCursor.isBeforeFirst()) {
            this.originalCursor.moveToFirst();
        }
        if (this.originalCursor.isAfterLast()) {
            this.originalCursor.moveToLast();
        }
        return this.construct();
    }

    @Override
    public T getFirst() {
        this.assertEmptyCursor();
        this.originalCursor.moveToFirst();
        return this.construct();
    }

    @Override
    public T getLast() {
        this.assertEmptyCursor();
        this.originalCursor.moveToLast();
        return this.construct();
    }

    @Override
    public T getNext() {
        this.assertEmptyCursor();
        if (!this.hasNext()) {
            throw new NoSuchElementException("There is no next element in cursor!");
        }
        this.originalCursor.moveToNext();
        return this.construct();
    }

    @Override
    public Collection<T> getNext(int amount) {
        this.assertEmptyCursor();
        if (!this.hasNext()) {
            throw new NoSuchElementException("There is no next element in cursor!");
        }
        ArrayList<T> instances = new ArrayList<T>(this.originalCursor.getCount());
        int count = 0;
        while (this.originalCursor.moveToNext() && count < amount) {
            if (this.originalCursor.isAfterLast()) continue;
            instances.add(this.construct());
            ++count;
        }
        return instances;
    }

    @Override
    public T getOne() {
        this.assertEmptyCursor();
        if (this.originalCursor.getCount() > 1) {
            throw new IllegalStateException("Expected only one element in cursor but there were " + this.originalCursor.getCount() + "!");
        }
        this.originalCursor.moveToFirst();
        return this.construct();
    }

    @Override
    public T getPrevious() {
        this.assertEmptyCursor();
        if (!this.hasPrevious()) {
            throw new NoSuchElementException("There is no previos element in cursor!");
        }
        this.originalCursor.moveToPrevious();
        return this.construct();
    }

    @Override
    public Collection<T> getPrevious(int amount) {
        this.assertEmptyCursor();
        if (!this.hasPrevious()) {
            throw new NoSuchElementException("There is no next element in cursor!");
        }
        ArrayList<T> instances = new ArrayList<T>(this.originalCursor.getCount());
        int count = 0;
        while (this.originalCursor.moveToPrevious() && count < amount) {
            if (this.originalCursor.isBeforeFirst()) continue;
            instances.add(this.construct());
            ++count;
        }
        return instances;
    }

    @Override
    public boolean hasNext() {
        return this.originalCursor.getCount() > 0 && !this.originalCursor.isLast() && !this.originalCursor.isAfterLast();
    }

    @Override
    public boolean hasPrevious() {
        return this.originalCursor.getCount() > 0 && !this.originalCursor.isFirst() && !this.originalCursor.isBeforeFirst();
    }

    @Override
    public Iterator<T> iterator() {
        this.moveBeforeFirst();
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return CombinedCursorImpl.this.hasNext();
            }

            @Override
            public T next() {
                return CombinedCursorImpl.this.getNext();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return this.originalCursor.getCount();
    }
}

