/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb.cursor;

import java.lang.reflect.Method;

class ReflectionUtil {
    ReflectionUtil() {
    }

    static Class<?>[] getArgTypes(Object[] args) {
        Class[] argTypes = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            argTypes[i] = args[i].getClass();
        }
        return argTypes;
    }

    static boolean isCloseMethod(Method method) {
        return method.getName().equals("close") && method.getParameterTypes().length == 0;
    }

    static boolean isMethodOfType(Method method, Class<?>[] argTypes, Class<?> type) {
        Method[] declaredMethods;
        for (Method declared : declaredMethods = type.getDeclaredMethods()) {
            Class<?>[] parameterTypes;
            if (!declared.getName().equals(method.getName()) || (parameterTypes = declared.getParameterTypes()).length != argTypes.length) continue;
            boolean matches = true;
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (ReflectionUtil.matches(parameterTypes[i], argTypes[i])) continue;
                matches = false;
            }
            if (!matches) continue;
            return true;
        }
        return false;
    }

    private static boolean isPrimitiveAssignable(Class<?> paramType, Class<?> argType) {
        if (paramType.equals(Boolean.TYPE) && argType.equals(Boolean.class)) {
            return true;
        }
        if (paramType.equals(Integer.TYPE) && argType.equals(Integer.class)) {
            return true;
        }
        if (paramType.equals(Character.TYPE) && argType.equals(Character.class)) {
            return true;
        }
        if (paramType.equals(Float.TYPE) && argType.equals(Float.class)) {
            return true;
        }
        if (paramType.equals(Double.TYPE) && argType.equals(Double.class)) {
            return true;
        }
        if (paramType.equals(Long.TYPE) && argType.equals(Long.class)) {
            return true;
        }
        return paramType.equals(Short.TYPE) && argType.equals(Short.class);
    }

    private static boolean matches(Class<?> paramType, Class<?> argType) {
        if (paramType.isAssignableFrom(argType)) {
            return true;
        }
        return ReflectionUtil.isPrimitiveAssignable(paramType, argType);
    }
}

