/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb.manifest;

import java.io.File;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.tools.Diagnostic;
import org.droitateddb.manifest.AndroidManifest;
import org.droitateddb.manifest.AndroidManifestProcessor;
import org.droitateddb.processor.ContentProviderData;

public class AndroidManifestAccess {
    private final ProcessingEnvironment env;
    private String generatedPackage;

    public AndroidManifestAccess(ProcessingEnvironment env) {
        this.env = env;
    }

    public final AndroidManifest load() throws Exception {
        return new AndroidManifestProcessor(this.openManifest(), this.generatedPackage).parse();
    }

    public void addProviders(List<ContentProviderData> data) throws Exception {
        AndroidManifestProcessor manifestParser = new AndroidManifestProcessor(this.openManifest(), this.generatedPackage);
        AndroidManifestProcessor.ManifestBuilder builder = manifestParser.change();
        for (ContentProviderData provider : data) {
            builder.addProviderIfNotExists(provider);
        }
        builder.commit();
    }

    private File openManifest() {
        String manifestFileName = this.env.getOptions().get("manifest");
        if (manifestFileName == null || "".equals(manifestFileName)) {
            this.env.getMessager().printMessage(Diagnostic.Kind.MANDATORY_WARNING, "Please configure the annotation processor option: manifest");
            throw new IllegalStateException("Provide a file path to your manifest file");
        }
        this.env.getMessager().printMessage(Diagnostic.Kind.NOTE, "Working with Android manifest: " + manifestFileName);
        File manifest = new File(manifestFileName);
        if (!manifest.exists()) {
            throw new IllegalStateException("Manifest file " + manifest.getAbsolutePath() + " does not exist!");
        }
        return manifest;
    }

    public void initGeneratedPackage(String generatedPackage) {
        this.generatedPackage = generatedPackage;
    }
}

