/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb.processor;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

public class JavaFileWriter {
    private final String packageName;
    private final String className;
    private final ProcessingEnvironment processingEnv;

    public JavaFileWriter(String packageName, String className, ProcessingEnvironment processingEnv) {
        this.packageName = packageName;
        this.className = className;
        this.processingEnv = processingEnv;
    }

    public void write(String data) {
        Writer writer = null;
        try {
            this.clearOldVersions(this.packageName, this.className);
            JavaFileObject file = this.processingEnv.getFiler().createSourceFile(this.packageName + "." + this.className, new Element[0]);
            writer = file.openWriter();
            writer.append(data).flush();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void clearOldVersions(String packageName, String fileName) {
        try {
            FileObject schema = this.processingEnv.getFiler().getResource(StandardLocation.SOURCE_OUTPUT, packageName, fileName);
            String schemaFile = schema.toUri().toASCIIString();
            String withoutFile = schemaFile.replace("file:", "") + ".java";
            if (new File(withoutFile).exists()) {
                new File(withoutFile).delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

