/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb.schema;

import java.util.Date;

public enum ColumnType {
    INTEGER("Integer"),
    REAL("Real"),
    BLOB("Blob"),
    TEXT("Text");

    private final String readable;

    private ColumnType(String readable) {
        this.readable = readable;
    }

    public String getReadable() {
        return this.readable;
    }

    public static ColumnType resolveColumnType(String type) {
        if (ColumnType.matches(String.class, type)) {
            return TEXT;
        }
        if (ColumnType.matches(Integer.class, type) || ColumnType.matches(Integer.TYPE, type) || ColumnType.matches(Boolean.class, type) || ColumnType.matches(Boolean.TYPE, type) || ColumnType.matches(Date.class, type) || ColumnType.matches(Long.class, type) || ColumnType.matches(Long.TYPE, type)) {
            return INTEGER;
        }
        if (ColumnType.matches(Double.class, type) || ColumnType.matches(Float.class, type) || ColumnType.matches(Double.TYPE, type) || ColumnType.matches(Float.TYPE, type)) {
            return REAL;
        }
        if (ColumnType.matches(byte[].class, type)) {
            return BLOB;
        }
        throw new IllegalStateException("The type " + type + " is no supported @Column type. Try @Relationship if you want to create an association.");
    }

    private static boolean matches(Class<?> ref, String match) {
        return ref.getCanonicalName().equals(match);
    }
}

