/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb.validation;

import org.droitateddb.validation.CustomValidator;
import org.droitateddb.validation.Length;
import org.droitateddb.validation.ValidationResult;

public class LengthValidator
implements CustomValidator<Length, String> {
    public static final int ERROR_CODE = 1;

    @Override
    public ValidationResult onValidate(Length length, String data) {
        long minLength = length.min();
        long maxLength = length.max();
        if (data == null) {
            return ValidationResult.valid();
        }
        if (minLength > -1L && (long)data.length() < minLength) {
            return ValidationResult.invalid(1, "The given data is to short. It should be between " + minLength + " and " + maxLength + " characters long.");
        }
        if (maxLength > -1L && (long)data.length() > maxLength) {
            return ValidationResult.invalid(1, "The given data is to long. It should be between " + minLength + " and " + maxLength + " characters long.");
        }
        return ValidationResult.valid();
    }
}

