/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb.validation;

import java.math.BigDecimal;
import org.droitateddb.validation.CustomValidator;
import org.droitateddb.validation.Max;
import org.droitateddb.validation.ValidationResult;

public class MaxValidator
implements CustomValidator<Max, Number> {
    public static final int ERROR_CODE = 3;

    @Override
    public ValidationResult onValidate(Max annotation, Number toByValidated) {
        long max = annotation.value();
        if (toByValidated == null) {
            return ValidationResult.valid();
        }
        if (new BigDecimal(toByValidated.toString()).compareTo(new BigDecimal(max)) <= 0) {
            return ValidationResult.valid();
        }
        return ValidationResult.invalid(3, "The field as to be less or equal to " + max);
    }
}

