/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb.validation;

public class ValidationResult {
    private final boolean valid;
    private final int errorCode;
    private final String errorMessage;

    private ValidationResult(boolean valid, int errorCode, String errorMessage) {
        this.valid = valid;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
    }

    public boolean isValid() {
        return this.valid;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static ValidationResult valid() {
        return new ValidationResult(true, 0, "");
    }

    public static ValidationResult invalid(int errorCode, String error) {
        return new ValidationResult(false, errorCode, error);
    }

    public String toString() {
        if (this.valid) {
            return "valid";
        }
        return "(" + this.errorCode + ") " + this.errorMessage;
    }
}

