/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.droitateddb.DbCreator;
import org.droitateddb.DbFunction;
import org.droitateddb.cursor.CombinedCursor;
import org.droitateddb.cursor.CombinedCursorImpl;
import org.droitateddb.schema.AbstractAttribute;
import org.droitateddb.schema.EntityInfo;

public abstract class BaseContentProvider
extends ContentProvider {
    private static final int MATCH_DIR = 0;
    private static final int MATCH_ITEM = 1;
    private static final String PROTOCOL = "content://";
    private static final UriRegistry REGISTRY = new UriRegistry();
    private final String contentUri;
    private final String dirContentType;
    private final String itemContentType;
    private DbCreator dbCreator;
    private final UriMatcher uriMatcher = new UriMatcher(-1);

    protected BaseContentProvider() {
        String authority = this.getAuthority();
        String base = this.getEntityURIPart();
        String typeDescription = "/vnd." + authority + "." + base;
        this.contentUri = PROTOCOL + authority + "/" + base;
        this.dirContentType = "vnd.android.cursor.dir" + typeDescription;
        this.itemContentType = "vnd.android.cursor.item" + typeDescription;
        this.uriMatcher.addURI(authority, base, 0);
        this.uriMatcher.addURI(authority, base + "/#", 1);
        REGISTRY.add(this.getTableName(), this.contentUri);
    }

    public static Uri uri(String tableName) {
        return REGISTRY.getDictionaryUri(tableName);
    }

    public static Uri uriForItem(String tableName, long id) {
        return REGISTRY.getItemUri(tableName, Long.toString(id));
    }

    protected abstract String getAuthority();

    protected abstract AbstractAttribute getIdAttribute();

    protected abstract EntityInfo getEntityInfo();

    protected String getEntityURIPart() {
        return "entity";
    }

    private String getTableName() {
        return this.getEntityInfo().table();
    }

    private String getIdName() {
        return this.getIdAttribute().fieldName();
    }

    public boolean onCreate() {
        this.dbCreator = DbCreator.getInstance(this.getContext());
        return true;
    }

    public String getType(Uri uri) {
        switch (this.uriMatcher.match(uri)) {
            case 0: {
                return this.dirContentType;
            }
            case 1: {
                return this.itemContentType;
            }
        }
        throw new UnsupportedOperationException("No type for Uri " + uri + " present");
    }

    public Uri insert(final Uri uri, final ContentValues values) {
        return this.dbCreator.functionOnDatabase(new DbFunction<Uri>(){

            @Override
            public Uri apply(SQLiteDatabase db) {
                switch (BaseContentProvider.this.uriMatcher.match(uri)) {
                    case 0: {
                        long id = db.insertWithOnConflict(BaseContentProvider.this.getTableName(), null, values, 5);
                        BaseContentProvider.this.getContext().getContentResolver().notifyChange(uri, null);
                        return Uri.parse((String)(BaseContentProvider.this.contentUri + "/" + id));
                    }
                }
                throw new UnsupportedOperationException("Insert not allowed with specific note uri");
            }
        });
    }

    public Cursor query(Uri uri, String[] projection, String selection, String[] selectionArgs, String sortOrder) {
        SQLiteDatabase db = this.dbCreator.getDatabaseConnection();
        SQLiteQueryBuilder builder = new SQLiteQueryBuilder();
        builder.setTables(this.getTableName());
        switch (this.uriMatcher.match(uri)) {
            case 0: {
                return this.wrap(builder.query(db, projection, selection, selectionArgs, null, null, sortOrder), uri);
            }
            case 1: {
                int id = Integer.parseInt(uri.getLastPathSegment());
                builder.appendWhere((CharSequence)(this.getIdName() + " = " + id));
                return this.wrap(builder.query(db, projection, selection, selectionArgs, null, null, sortOrder), uri);
            }
        }
        throw new UnsupportedOperationException("Unsupported query Uri " + uri);
    }

    public int update(final Uri uri, final ContentValues values, final String selection, final String[] selectionArgs) {
        return this.dbCreator.functionOnDatabase(new DbFunction<Integer>(){

            @Override
            public Integer apply(SQLiteDatabase db) {
                switch (BaseContentProvider.this.uriMatcher.match(uri)) {
                    case 0: {
                        return db.update(BaseContentProvider.this.getTableName(), values, selection, selectionArgs);
                    }
                    case 1: {
                        String selectId = BaseContentProvider.this.getIdName() + " = " + Integer.parseInt(uri.getLastPathSegment());
                        return db.update(BaseContentProvider.this.getTableName(), values, BaseContentProvider.this.getEffectivSelection(selection, selectId), selectionArgs);
                    }
                }
                throw new UnsupportedOperationException("Update not supported for the given Uri + " + uri + ". Only single item updates are allowed right " + "now");
            }
        });
    }

    public int delete(final Uri uri, final String selection, final String[] selectionArgs) {
        return this.dbCreator.functionOnDatabase(new DbFunction<Integer>(){

            @Override
            public Integer apply(SQLiteDatabase db) {
                switch (BaseContentProvider.this.uriMatcher.match(uri)) {
                    case 0: {
                        return db.delete(BaseContentProvider.this.getTableName(), selection, selectionArgs);
                    }
                    case 1: {
                        String selectId = BaseContentProvider.this.getIdName() + " = " + Integer.parseInt(uri.getLastPathSegment());
                        return db.delete(BaseContentProvider.this.getTableName(), BaseContentProvider.this.getEffectivSelection(selection, selectId), selectionArgs);
                    }
                }
                throw new UnsupportedOperationException("Delete not supported for the given Uri + " + uri + ". Only single item deletes are allowed right now");
            }
        });
    }

    private Cursor wrap(Cursor cursor, Uri uri) {
        try {
            EntityInfo entityInfo = this.getEntityInfo();
            CombinedCursor<?> magicCursor = CombinedCursorImpl.create(this.getContext(), cursor, entityInfo, Class.forName(entityInfo.className()));
            magicCursor.setNotificationUri(this.getContext().getContentResolver(), uri);
            return magicCursor;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private String getEffectivSelection(String submitedSelection, String idSelection) {
        String effectivSelection = submitedSelection == null || submitedSelection.equals("") ? idSelection : submitedSelection + " AND " + idSelection;
        return effectivSelection;
    }

    private static class UriRegistry {
        private final Map<String, String> registry = new ConcurrentHashMap<String, String>();

        private UriRegistry() {
        }

        public void add(String tableName, String uri) {
            this.registry.put(tableName, uri);
        }

        public Uri getDictionaryUri(String tableName) {
            return Uri.parse((String)this.getRegisteredUri(tableName));
        }

        public Uri getItemUri(String tableName, String id) {
            return Uri.parse((String)(this.getRegisteredUri(tableName) + "/" + id));
        }

        private String getRegisteredUri(String tableName) {
            String uri = this.registry.get(tableName);
            if (uri == null) {
                throw new IllegalStateException("No ContentProvider Uri was registered for table " + tableName + ". Did you forget to set \"contentProvider=true\" on the corresponding @Entity annotation?");
            }
            return uri;
        }
    }
}

