/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;

class DatabaseValidatorAnnotationHandler
implements InvocationHandler {
    private final Object[] params;

    public DatabaseValidatorAnnotationHandler(Object[] params) {
        this.params = params;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        for (int i = 0; i < this.params.length; i += 2) {
            if (!this.params[i].equals(method.getName())) continue;
            Object param = this.params[i + 1];
            if (Number.class.isAssignableFrom(param.getClass())) {
                Class<?> returnType = method.getReturnType();
                return this.handleNumber((Number)param, returnType);
            }
            return param;
        }
        return null;
    }

    private Object handleNumber(Number number, Class<?> returnType) {
        if (returnType.equals(Long.TYPE)) {
            return number.longValue();
        }
        if (returnType.equals(Integer.TYPE)) {
            return number.intValue();
        }
        if (returnType.equals(Byte.TYPE)) {
            return number.byteValue();
        }
        if (returnType.equals(Double.TYPE)) {
            return number.doubleValue();
        }
        if (returnType.equals(Float.TYPE)) {
            return Float.valueOf(number.floatValue());
        }
        if (returnType.equals(Short.TYPE)) {
            return number.shortValue();
        }
        return null;
    }
}

