/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import java.util.concurrent.atomic.AtomicInteger;
import org.droitateddb.DbClosingCursor;
import org.droitateddb.DbConsumer;
import org.droitateddb.DbFunction;
import org.droitateddb.PersistenceDefinition;
import org.droitateddb.hooks.DbCreate;
import org.droitateddb.hooks.DbUpdate;

public class DbCreator
extends SQLiteOpenHelper {
    private static final Object LOCK = new Object();
    private static final AtomicInteger OPEN_CONNECTIONS = new AtomicInteger(0);
    private static PersistenceDefinition PERSISTENCE_DEFINITION;
    private static DbCreator DB_CREATOR_INSTANCE;
    protected static volatile SQLiteDatabase dbConnection;
    private final PersistenceDefinition persistence;

    protected DbCreator(Context context, PersistenceDefinition persistence) {
        super(context, persistence.getName(), null, persistence.getVersion());
        this.persistence = persistence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DbCreator getInstance(Context context) {
        Object object = LOCK;
        synchronized (object) {
            if (PERSISTENCE_DEFINITION == null) {
                PERSISTENCE_DEFINITION = PersistenceDefinition.create(context.getApplicationContext());
            }
            if (DB_CREATOR_INSTANCE == null) {
                DB_CREATOR_INSTANCE = new DbCreator(context, PERSISTENCE_DEFINITION);
            }
            return DB_CREATOR_INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLiteDatabase getDatabaseConnection() {
        Object object = LOCK;
        synchronized (object) {
            if (dbConnection == null) {
                OPEN_CONNECTIONS.set(0);
                dbConnection = super.getWritableDatabase();
            }
            OPEN_CONNECTIONS.incrementAndGet();
            return dbConnection;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reduceDatabaseConnection() {
        Object object = LOCK;
        synchronized (object) {
            int numberOfOpenConnections = OPEN_CONNECTIONS.decrementAndGet();
            if (numberOfOpenConnections == 0 && dbConnection != null) {
                dbConnection.close();
                dbConnection = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T functionOnDatabase(DbFunction<T> dbFunction) {
        SQLiteDatabase db = this.getDatabaseConnection();
        try {
            T t = dbFunction.apply(db);
            return t;
        }
        finally {
            this.reduceDatabaseConnection();
        }
    }

    public void consumeDatabase(DbConsumer dbConsumer) {
        SQLiteDatabase db = this.getDatabaseConnection();
        try {
            dbConsumer.consume(db);
        }
        finally {
            this.reduceDatabaseConnection();
        }
    }

    public Cursor query(String table, String[] columns, String selection, String[] selectionArgs, String groupBy, String having, String orderBy) {
        SQLiteDatabase db = this.getDatabaseConnection();
        return new DbClosingCursor(db.query(table, columns, selection, selectionArgs, groupBy, having, orderBy), this);
    }

    public Cursor rawQuery(String sql) {
        SQLiteDatabase db = this.getDatabaseConnection();
        return new DbClosingCursor(db.rawQuery(sql, null), this);
    }

    @Deprecated
    public synchronized SQLiteDatabase getReadableDatabase() {
        throw new UnsupportedOperationException("Use getDatabaseConnection and reduceDatabaseConnection or one of the performOnDatabase methods");
    }

    @Deprecated
    public synchronized SQLiteDatabase getWritableDatabase() {
        throw new UnsupportedOperationException("Use getDatabaseConnection and reduceDatabaseConnection or one of the performOnDatabase methods");
    }

    public void onCreate(SQLiteDatabase db) {
        for (String statement : this.persistence.getSqlCreationStatements()) {
            db.execSQL(statement);
        }
        for (String index : this.persistence.getIndexStatements()) {
            db.execSQL(index);
        }
        Class<?> createHook = this.persistence.getCreateHook();
        if (createHook != null) {
            try {
                DbCreate createHookInstance = (DbCreate)createHook.newInstance();
                createHookInstance.onCreate(db);
            }
            catch (Exception e) {
                throw new IllegalStateException("Couldn't invoke the create hook", e);
            }
        }
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        Class<?> updateHook = this.persistence.getUpdateHook();
        if (updateHook != null) {
            try {
                DbUpdate updater = (DbUpdate)updateHook.newInstance();
                updater.onUpdate(db, oldVersion, newVersion);
            }
            catch (Exception e) {
                throw new IllegalStateException("Couldn't invoke the update hook", e);
            }
        }
    }
}

