/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import org.droitateddb.CursorOperation;
import org.droitateddb.DatabaseResolver;
import org.droitateddb.DatabaseSaver;
import org.droitateddb.DatabaseValidator;
import org.droitateddb.DbCreator;
import org.droitateddb.EntityData;
import org.droitateddb.SchemaUtil;
import org.droitateddb.Utilities;
import org.droitateddb.cursor.CombinedCursorImpl;
import org.droitateddb.entity.Column;
import org.droitateddb.entity.Entity;
import org.droitateddb.entity.PrimaryKey;
import org.droitateddb.schema.EntityInfo;
import org.droitateddb.validation.AccumulatedValidationResult;
import org.droitateddb.validation.InvalidEntityException;
import org.droitateddb.validation.ValidationToggle;

public class EntityService<E> {
    private final Context context;
    private final Class<E> entityClass;
    private String tableName;
    private final EntityInfo entityInfo;
    private LinkedList<Field> columns;
    private Field primaryKey;
    protected DbCreator dbCreator;
    private DatabaseValidator<E> databaseValidator;
    private ValidationToggle toggle;

    public EntityService(Context context, Class<E> entityClass) {
        this(context, entityClass, ValidationToggle.ON, DbCreator.getInstance(context));
    }

    public EntityService(Context context, Class<E> entityClass, ValidationToggle toggle) {
        this(context, entityClass, toggle, DbCreator.getInstance(context));
    }

    EntityService(Context context, Class<E> entityClass, ValidationToggle toggle, DbCreator dbCreator) {
        if (entityClass.getAnnotation(Entity.class) == null) {
            throw new IllegalArgumentException("The EntityService can only be used for @Entity annotated classes");
        }
        this.context = context;
        this.entityClass = entityClass;
        this.entityInfo = SchemaUtil.getEntityInfo(entityClass, context.getPackageName());
        this.tableName = SchemaUtil.getTableName(entityClass, context.getPackageName());
        this.toggle = toggle;
        this.dbCreator = dbCreator;
        this.databaseValidator = new DatabaseValidator(context);
        this.initColumns();
    }

    private void initColumns() {
        this.columns = new LinkedList();
        TreeSet<String> names = new TreeSet<String>();
        for (Field field : this.entityClass.getDeclaredFields()) {
            if (field.getAnnotation(Column.class) == null) continue;
            if (field.getAnnotation(PrimaryKey.class) != null) {
                this.primaryKey = field;
            }
            this.columns.add(field);
            names.add(field.getName());
        }
    }

    public List<E> get() {
        return this.find(null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public E get(int id) {
        SQLiteDatabase database = this.openDB();
        try {
            Cursor cursor = database.query(this.tableName, null, this.primaryKey.getName() + " = ?", new String[]{Integer.toString(id)}, null, null, null);
            if (cursor.getCount() == 0) {
                E e = null;
                return e;
            }
            Object t = CursorOperation.tryOnCursor(cursor, new CursorOperation<E>(){

                @Override
                public E execute(Cursor cursor) {
                    return CombinedCursorImpl.create(EntityService.this.context, cursor, EntityService.this.entityInfo, EntityService.this.entityClass).getCurrent();
                }
            });
            return (E)t;
        }
        finally {
            this.closeDB(database);
        }
    }

    protected void closeDB(SQLiteDatabase database) {
        this.dbCreator.reduceDatabaseConnection();
    }

    protected SQLiteDatabase openDB() {
        return this.dbCreator.getDatabaseConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<E> find(String selection, String[] selectionArgs, String order) {
        SQLiteDatabase database = this.openDB();
        try {
            Cursor cursor = database.query(this.tableName, null, selection, selectionArgs, null, null, order);
            List list = (List)CursorOperation.tryOnCursor(cursor, new CursorOperation<List<E>>(){

                @Override
                public List<E> execute(Cursor cursor) {
                    return new ArrayList(CombinedCursorImpl.create(EntityService.this.context, cursor, EntityService.this.entityInfo, EntityService.this.entityClass).getAll());
                }
            });
            return list;
        }
        finally {
            this.closeDB(database);
        }
    }

    public void resolveAssociations(E data) {
        SQLiteDatabase database = this.openDB();
        try {
            new DatabaseResolver(this.context, database).resolve(data, 0, Integer.MAX_VALUE);
        }
        finally {
            this.closeDB(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resolveAssociations(E data, int maxDepth) {
        SQLiteDatabase database = this.openDB();
        try {
            new DatabaseResolver(this.context, database).resolve(data, 0, maxDepth);
        }
        finally {
            this.closeDB(database);
        }
    }

    public int save(E data) {
        return this.save(data, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int save(final E data, final int maxDepth) {
        AccumulatedValidationResult validationResult;
        if (this.toggle == ValidationToggle.ON && !(validationResult = this.databaseValidator.validate(data, maxDepth)).isValid()) {
            throw new InvalidEntityException(validationResult);
        }
        final SQLiteDatabase database = this.openDB();
        try {
            int n = this.transactional(database, new DatabaseOperation<Integer>(){

                @Override
                public Integer execute() {
                    return new DatabaseSaver(EntityService.this.context, database, maxDepth).save(data);
                }
            });
            return n;
        }
        finally {
            this.closeDB(database);
        }
    }

    public void save(Collection<E> data) {
        this.save(data, Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(final Collection<E> data, int maxDepth) {
        AccumulatedValidationResult validationResult;
        if (this.toggle == ValidationToggle.ON && !(validationResult = this.databaseValidator.validate((E)data, maxDepth)).isValid()) {
            throw new InvalidEntityException(validationResult);
        }
        SQLiteDatabase database = this.openDB();
        try {
            final DatabaseSaver databaseSaver = new DatabaseSaver(this.context, database, maxDepth);
            this.transactional(database, new DatabaseOperation<Void>(){

                @Override
                public Void execute() {
                    for (Object object : data) {
                        databaseSaver.save(object);
                    }
                    return null;
                }
            });
        }
        finally {
            this.closeDB(database);
        }
    }

    public boolean delete(E data) {
        Integer id = (Integer)Utilities.getFieldValue(data, this.primaryKey);
        if (id == null) {
            throw new IllegalArgumentException("The @PrimaryKey of the given @Entity can not be null");
        }
        return this.delete(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(int id) {
        SQLiteDatabase database = this.openDB();
        try {
            int delete = database.delete(this.tableName, EntityData.getEntityData(this.entityClass).primaryKey.getName() + "= ?", new String[]{Integer.toString(id)});
            boolean bl = delete == 1;
            return bl;
        }
        finally {
            this.closeDB(database);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T transactional(SQLiteDatabase database, DatabaseOperation<T> operation) {
        database.beginTransaction();
        try {
            T result = operation.execute();
            database.setTransactionSuccessful();
            T t = result;
            return t;
        }
        finally {
            database.endTransaction();
        }
    }

    @Deprecated
    public void close() {
    }

    private static interface DatabaseOperation<E> {
        public E execute();
    }
}

