/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb;

import android.content.Context;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class PersistenceDefinition {
    private final String name;
    private final int version;
    private final ArrayList<String> sqlCreationStatements = new ArrayList();
    private final ArrayList<String> indexStatements = new ArrayList();
    private final Class<?> updateHook;
    private final Class<?> createHook;

    public PersistenceDefinition(String name, int version, Class<?> updateHook, Class<?> createHook, List<String> sqlCreationStatements, List<String> indexStatements) {
        this.name = name;
        this.version = version;
        this.updateHook = updateHook;
        this.createHook = createHook;
        this.sqlCreationStatements.addAll(sqlCreationStatements);
        this.indexStatements.addAll(indexStatements);
    }

    public String getName() {
        return this.name;
    }

    public int getVersion() {
        return this.version;
    }

    public Class<?> getUpdateHook() {
        return this.updateHook;
    }

    public Class<?> getCreateHook() {
        return this.createHook;
    }

    public List<String> getSqlCreationStatements() {
        return Collections.unmodifiableList(this.sqlCreationStatements);
    }

    public List<String> getIndexStatements() {
        return Collections.unmodifiableList(this.indexStatements);
    }

    public static PersistenceDefinition create(Context context) {
        return PersistenceDefinition.loadPersistenceData(context);
    }

    private static PersistenceDefinition loadPersistenceData(Context context) {
        try {
            Class<?> schemaClass = Class.forName(context.getPackageName() + "." + "generated" + "." + "DB");
            String dbName = (String)schemaClass.getDeclaredField("DB_NAME").get(null);
            int dbVersion = (Integer)schemaClass.getDeclaredField("DB_VERSION").get(null);
            Class<?> updateHook = PersistenceDefinition.getHook(schemaClass, "DB_UPDATE_HOOK");
            Class<?> createHook = PersistenceDefinition.getHook(schemaClass, "DB_CREATE_HOOK");
            Class<?>[] tableDefinitions = schemaClass.getDeclaredClasses();
            ArrayList<String> creationStatements = new ArrayList<String>(tableDefinitions.length);
            ArrayList<String> indexStatements = new ArrayList<String>(tableDefinitions.length);
            for (Class<?> def : tableDefinitions) {
                Field[] allFields;
                if (!def.isInterface() || !def.getSimpleName().endsWith("Table") && !def.getSimpleName().endsWith("Association")) continue;
                String statement = (String)def.getDeclaredField("SQL_CREATION").get(null);
                creationStatements.add(statement);
                for (Field field : allFields = def.getDeclaredFields()) {
                    if (!field.getName().startsWith("SQL_INDEX")) continue;
                    indexStatements.add((String)field.get(null));
                }
            }
            return new PersistenceDefinition(dbName, dbVersion, updateHook, createHook, creationStatements, indexStatements);
        }
        catch (Exception e) {
            throw new IllegalStateException("Couldn't parse persistence data from DB class", e);
        }
    }

    private static Class<?> getHook(Class<?> schemaClass, String hookName) {
        Class<?> hook = null;
        try {
            Field hookField = schemaClass.getDeclaredField(hookName);
            if (hookField != null) {
                hook = Class.forName((String)hookField.get(null));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hook;
    }
}

