/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb;

import java.lang.reflect.Field;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.droitateddb.schema.EntityInfo;
import org.droitateddb.schema.ToManyAssociation;

class SchemaUtil {
    private static final String ASSOCIATION_TEMPLATE = "%s.generated.DB$%sTable$Associations";
    private static final String SCHEMA_TEMPLATE = "%s.generated.DB$%sTable";
    private static final String DB_TEMPLATE = "%s.generated.DB";
    private static final ConcurrentMap<Class<?>, String> TABLE_NAME_CACHE = new ConcurrentHashMap();
    private static final ConcurrentMap<Class<?>, Class<?>> ASSOCIATION_SCHEMA_CACHE = new ConcurrentHashMap();
    private static final ConcurrentMap<Class<?>, EntityInfo> ENTITY_INFO_CACHE = new ConcurrentHashMap();

    SchemaUtil() {
    }

    static String getTableName(Class<?> entityClass, String packageName) {
        if (TABLE_NAME_CACHE.containsKey(entityClass)) {
            return (String)TABLE_NAME_CACHE.get(entityClass);
        }
        try {
            String className = String.format(SCHEMA_TEMPLATE, packageName, entityClass.getSimpleName());
            Class<?> schemaClass = Class.forName(className);
            String tableName = (String)schemaClass.getField("TABLE_NAME").get(null);
            TABLE_NAME_CACHE.putIfAbsent(entityClass, tableName);
            return tableName;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    static Class<?> getAssociationsSchema(Class<?> entityClass, String packageName) {
        if (ASSOCIATION_SCHEMA_CACHE.containsKey(entityClass)) {
            ASSOCIATION_SCHEMA_CACHE.get(entityClass);
        }
        try {
            Class<?> associationsSchema = Class.forName(String.format(ASSOCIATION_TEMPLATE, packageName, entityClass.getSimpleName()));
            ASSOCIATION_SCHEMA_CACHE.putIfAbsent(entityClass, associationsSchema);
            return associationsSchema;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    static EntityInfo getEntityInfo(Class<?> entityClass, String packageName) {
        if (ENTITY_INFO_CACHE.containsKey(entityClass)) {
            return (EntityInfo)ENTITY_INFO_CACHE.get(entityClass);
        }
        try {
            EntityInfo entityInfo = (EntityInfo)Class.forName(String.format(DB_TEMPLATE, packageName)).getField(entityClass.getSimpleName() + "Info").get(null);
            ENTITY_INFO_CACHE.putIfAbsent(entityClass, entityInfo);
            return entityInfo;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    static ToManyAssociation getToManyAsso(Field associationField, Class<?> associationsSchema) {
        try {
            Field toManyAssociationInfo = associationsSchema.getDeclaredField(associationField.getName().toUpperCase(Locale.getDefault()));
            return (ToManyAssociation)toManyAssociationInfo.get(null);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

