/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb.builder.provider;

import java.util.Locale;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import org.droitateddb.builder.provider.PrimaryKeyVisitor;
import org.droitateddb.builder.provider.SourceContentProviderData;
import org.droitateddb.entity.Entity;

public class ContentProviderBuilder {
    private final Element entityElement;
    private final Entity entity;
    private final String packageName;
    private final String entityName;
    private final VariableElement primaryKey;
    private final Messager messager;
    public static final String CONTENT_PROVIDER_SUFFIX = "ContentProvider";

    public ContentProviderBuilder(String packageName, Element entityElement, Messager messager) {
        this.packageName = packageName;
        this.entityElement = entityElement;
        this.messager = messager;
        this.entityName = entityElement.getSimpleName().toString();
        this.entity = entityElement.getAnnotation(Entity.class);
        this.primaryKey = this.getPrimaryKey();
    }

    private VariableElement getPrimaryKey() {
        for (Element element : this.entityElement.getEnclosedElements()) {
            VariableElement variableElement = element.accept(new PrimaryKeyVisitor(), null);
            if (variableElement == null) continue;
            return variableElement;
        }
        String error = "The @Entity " + this.entityName + " has no @PrimaryKey. @PrimaryKey is required";
        this.messager.printMessage(Diagnostic.Kind.ERROR, error, this.entityElement);
        throw new IllegalStateException(error);
    }

    public SourceContentProviderData build() {
        String providerName = this.entityName + CONTENT_PROVIDER_SUFFIX;
        String authority = this.getAuthority();
        StringBuilder builder = new StringBuilder();
        this.addSignature(builder, providerName);
        this.overrideEntityUriPart(builder);
        this.overrideGetAuthority(builder, authority);
        this.overrideGetEntityInfo(builder);
        this.overrideGetIdAttribute(builder);
        this.addEnd(builder);
        String source = builder.toString();
        return new SourceContentProviderData(this.packageName, providerName, source, authority, this.entity.exported());
    }

    private void addSignature(StringBuilder builder, String providerName) {
        builder.append("/** Automatically generated file. DO NOT MODIFY */\n");
        builder.append("package ").append(this.packageName).append(";\n\n").append("import ").append("org.droitateddb.schema.*;\n").append("import ").append("org.droitateddb.*;\n").append("public class ").append(providerName).append(" extends BaseContentProvider {\n\n");
    }

    private void overrideEntityUriPart(StringBuilder builder) {
        builder.append("    ").append("@Override\n").append("    ").append("protected String getEntityURIPart() {\n").append("    ").append("    ").append("return \"").append(this.entityName.toLowerCase(Locale.getDefault())).append("\";\n").append("    ").append("}\n\n");
    }

    private void overrideGetAuthority(StringBuilder builder, String authority) {
        builder.append("    ").append("@Override\n").append("    ").append("protected String getAuthority() {\n").append("    ").append("return \"").append(authority).append("\";\n").append("    ").append("}\n\n");
    }

    private void overrideGetEntityInfo(StringBuilder builder) {
        builder.append("    ").append("@Override\n");
        builder.append("    ").append("protected EntityInfo getEntityInfo() {\n");
        builder.append("    ").append("    ").append("return ").append("DB").append(".").append(this.entityName).append("Info").append(";\n");
        builder.append("    ").append("}\n\n");
    }

    private void overrideGetIdAttribute(StringBuilder builder) {
        builder.append("    ").append("@Override\n");
        builder.append("    ").append("protected AbstractAttribute getIdAttribute() {\n");
        builder.append("    ").append("    ").append("return ").append("DB").append(".").append(this.entityName).append("Table").append(".").append(this.primaryKey.getSimpleName().toString().toUpperCase(Locale.getDefault())).append(";\n");
        builder.append("    ").append("}\n");
    }

    private void addEnd(StringBuilder builder) {
        builder.append("}");
    }

    private String getAuthority() {
        String authority = this.entity.authority();
        if (authority == null || authority.equals("")) {
            return this.packageName + ".provider." + this.entityName.toLowerCase(Locale.getDefault());
        }
        return authority;
    }
}

