/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb.builder.schema.reader;

import java.util.Collection;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.Messager;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import org.droitateddb.builder.schema.data.Association;
import org.droitateddb.builder.schema.reader.Reader;
import org.droitateddb.schema.AssociationType;

public class AssociationReader
implements Reader<Association> {
    private final VariableElement association;
    private final Set<String> entityNames;
    private final Messager messager;

    public AssociationReader(VariableElement association, Set<String> entityNames, Messager messager) {
        this.association = association;
        this.entityNames = entityNames;
        this.messager = messager;
    }

    @Override
    public Association read() {
        boolean isCollectionType;
        String nameInEntity = this.association.getSimpleName().toString();
        String typeInEntity = this.association.asType().toString();
        String canonicalType = this.getUsedType(this.association, typeInEntity, isCollectionType = typeInEntity.startsWith(Collection.class.getCanonicalName()));
        if ("".equals(canonicalType)) {
            return null;
        }
        int lastDot = canonicalType.lastIndexOf(".");
        String simpleType = canonicalType.substring(lastDot + 1, canonicalType.length());
        AssociationType cardinality = isCollectionType ? AssociationType.TO_MANY : AssociationType.TO_ONE;
        return new Association(nameInEntity, canonicalType, simpleType, cardinality);
    }

    private String getUsedType(VariableElement association, String fieldType, boolean isCollectionType) {
        if (!isCollectionType) {
            if (this.entityNames.contains(fieldType)) {
                return fieldType;
            }
            this.messager.printMessage(Diagnostic.Kind.ERROR, "The @Relationship has to be another @Entity or Collection of another @Entity", association);
            return "";
        }
        Matcher matcher = Pattern.compile("<(.*?)>").matcher(fieldType);
        if (matcher.find()) {
            String type = matcher.group(1);
            if (!this.entityNames.contains(type)) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "The collection type has to be an @Entity", association);
                return "";
            }
            return type;
        }
        this.messager.printMessage(Diagnostic.Kind.ERROR, "No raw type is allowed when using @Relationship on a Collection", association);
        return "";
    }
}

