/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb.builder.schema.writer;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.droitateddb.builder.schema.data.Column;
import org.droitateddb.builder.schema.data.ColumnValidation;
import org.droitateddb.builder.schema.data.ValidatorInfo;
import org.droitateddb.builder.schema.writer.Writer;
import org.droitateddb.schema.ColumnValidator;

public class ColumnWriter
implements Writer {
    private final String indent;
    private final Column column;
    private final int columnIdx;

    public ColumnWriter(String indent, Column column, int columnIdx) {
        this.indent = indent;
        this.column = column;
        this.columnIdx = columnIdx;
    }

    @Override
    public String write() {
        String columnType = this.column.getTypeInDb().getReadable();
        StringBuilder builder = new StringBuilder();
        String nameToUpper = this.column.getNameInEntity().toUpperCase(Locale.getDefault());
        builder.append(this.indent).append("    ").append("public static final ").append(columnType).append("Attribute").append(" ").append(nameToUpper).append(" = new ").append(columnType).append("Attribute").append("(\"").append(this.column.getNameInEntity()).append("\", ").append(this.column.getTypeInEntity()).append(".class, ").append(this.columnIdx);
        this.appendColumnValidators(builder);
        builder.append(");\n");
        return builder.toString();
    }

    private void appendColumnValidators(StringBuilder builder) {
        ColumnValidation columnValidation = this.column.getColumnValidation();
        int amountOfValidator = columnValidation.size();
        if (amountOfValidator > 0) {
            builder.append(", ");
            for (int i = 0; i < amountOfValidator; ++i) {
                this.addColumnValidator(builder, columnValidation.get(i));
                if (i >= amountOfValidator - 1) continue;
                builder.append(", ");
            }
        }
    }

    private void addColumnValidator(StringBuilder builder, ValidatorInfo validatorInfo) {
        builder.append("new ").append(ColumnValidator.class.getSimpleName()).append("(").append(validatorInfo.getValidatorAnnotation()).append(".class").append(", ").append(validatorInfo.getValidatorClass()).append(".class");
        int count = 0;
        Set<Map.Entry<String, Object>> entries = validatorInfo.getParameter().entrySet();
        int amountOfParams = entries.size();
        if (amountOfParams > 0) {
            builder.append(", ");
            for (Map.Entry<String, Object> param : entries) {
                builder.append("\"").append(param.getKey()).append("\"").append(", ");
                Object value = param.getValue();
                if (value.getClass().equals(String.class)) {
                    builder.append("\"").append(value).append("\"");
                } else {
                    builder.append(value);
                }
                if (count++ >= amountOfParams - 1) continue;
                builder.append(", ");
            }
        }
        builder.append(")");
    }

    public String getSql() {
        StringBuilder builder = new StringBuilder(this.column.getNameInEntity());
        builder.append(" ").append(this.column.getTypeInDb().getReadable());
        if (this.column.isPrimary()) {
            builder.append(" PRIMARY KEY");
        }
        if (this.column.isAutoincrementing()) {
            builder.append(" AUTOINCREMENT");
        }
        return builder.toString();
    }
}

