/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb.schema;

import android.database.Cursor;
import org.droitateddb.schema.ColumnType;
import org.droitateddb.schema.ColumnValidator;

public abstract class AbstractAttribute {
    private final String fieldName;
    private final String columnName;
    private final Class<?> fieldType;
    private final ColumnType type;
    private final int columnIdx;
    private final ColumnValidator[] columnValidators;

    public AbstractAttribute(ColumnType type, String fieldName, Class<?> fieldType, int columnIdx, ColumnValidator ... columnValidators) {
        this(type, fieldName, fieldName, fieldType, columnIdx, columnValidators);
    }

    public AbstractAttribute(ColumnType type, String fieldName, String columnName, Class<?> fieldType, int columnIdx, ColumnValidator ... columnValidators) {
        this.type = type;
        this.fieldName = fieldName;
        this.columnName = columnName;
        this.fieldType = fieldType;
        this.columnIdx = columnIdx;
        this.columnValidators = columnValidators == null ? new ColumnValidator[0] : columnValidators;
    }

    public String fieldName() {
        return this.fieldName;
    }

    public String columnName() {
        return this.columnName;
    }

    public int columnIndex() {
        return this.columnIdx;
    }

    public Class<?> type() {
        return this.fieldType;
    }

    public ColumnType sqliteType() {
        return this.type;
    }

    public ColumnValidator[] getColumnValidators() {
        return this.columnValidators;
    }

    public String toString() {
        return this.columnName();
    }

    public Object getValueFromCursor(Cursor originalCursor) {
        if (originalCursor.isNull(this.columnIdx) && !this.isPrimitiveField()) {
            return null;
        }
        return this.getNonNullValueFromCursor(originalCursor);
    }

    protected abstract Object getNonNullValueFromCursor(Cursor var1);

    private final boolean isPrimitiveField() {
        Class<?> paramType = this.type();
        return paramType.equals(Boolean.TYPE) || paramType.equals(Integer.TYPE) || paramType.equals(Character.TYPE) || paramType.equals(Float.TYPE) || paramType.equals(Double.TYPE) || paramType.equals(Long.TYPE) || paramType.equals(Short.TYPE);
    }
}

