/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb.validation;

import java.util.List;
import org.droitateddb.validation.AccumulatedValidationResult;
import org.droitateddb.validation.ValidationResult;

public class InvalidEntityException
extends RuntimeException {
    private List<ValidationResult> errors;

    public InvalidEntityException(AccumulatedValidationResult errors) {
        super(InvalidEntityException.flatten(errors));
        this.errors = errors.getErrors();
    }

    private static String flatten(AccumulatedValidationResult errors) {
        if (errors == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        List<ValidationResult> validationResults = errors.getErrors();
        for (int i = 0; i < validationResults.size(); ++i) {
            builder.append(validationResults.get(i));
            if (i >= validationResults.size() - 1) continue;
            builder.append(" | ");
        }
        return builder.toString();
    }

    public List<ValidationResult> getErrors() {
        return this.errors;
    }
}

