/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb;

import android.database.Cursor;
import android.database.CursorWrapper;
import org.droitateddb.cursor.ObjectCursor;

public class CursorUtil {
    public static <T> ObjectCursor<T> getObjectCursor(Cursor cursor) {
        if (cursor == null) {
            throw new NullPointerException("The given cursor is null");
        }
        if (!(cursor instanceof CursorWrapper)) {
            throw new IllegalArgumentException("The given cursor is not of type " + CursorWrapper.class.getCanonicalName() + ". It has type " + cursor.getClass().getCanonicalName() + ". Was it queried with a ContentResolver?");
        }
        CursorWrapper wrapper = (CursorWrapper)cursor;
        Cursor wrappedCursor = wrapper.getWrappedCursor();
        if (!(wrappedCursor instanceof ObjectCursor)) {
            throw new IllegalStateException("The wrapped cursor of the given CursorWrapper is not of type " + ObjectCursor.class.getCanonicalName() + ". It has type " + wrappedCursor.getClass().getCanonicalName() + ". Was it queried over a ContentResolver from BaseContentProvider derived ContentProvider?");
        }
        return (ObjectCursor)wrappedCursor;
    }
}

