/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.droitateddb.entity.AutoIncrement;
import org.droitateddb.entity.Column;
import org.droitateddb.entity.PrimaryKey;
import org.droitateddb.entity.Relationship;

final class EntityData {
    Field primaryKey;
    boolean autoIncrement;
    List<Field> columns = new ArrayList<Field>();
    List<Field> toManyAssociations = new ArrayList<Field>();
    List<Field> toOneAssociations = new ArrayList<Field>();
    List<Field> allAssociations = new ArrayList<Field>();
    Class<?> type;
    private static final ConcurrentMap<Class<?>, EntityData> ENTITY_DATA_CACHE = new ConcurrentHashMap();

    EntityData() {
    }

    static EntityData getEntityData(Object entity) {
        return EntityData.getEntityData(entity.getClass());
    }

    static EntityData getEntityData(Class<?> entityClass) {
        if (ENTITY_DATA_CACHE.containsKey(entityClass)) {
            return (EntityData)ENTITY_DATA_CACHE.get(entityClass);
        }
        EntityData entityData = new EntityData();
        entityData.type = entityClass;
        for (Field field : entityClass.getDeclaredFields()) {
            if (field.getAnnotation(Column.class) != null) {
                entityData.columns.add(field);
                if (field.getAnnotation(PrimaryKey.class) == null) continue;
                entityData.primaryKey = field;
                if (field.getAnnotation(AutoIncrement.class) == null) continue;
                entityData.autoIncrement = true;
                continue;
            }
            if (field.getAnnotation(Relationship.class) == null) continue;
            if (Collection.class.equals(field.getType())) {
                entityData.toManyAssociations.add(field);
            } else {
                entityData.toOneAssociations.add(field);
            }
            entityData.allAssociations.add(field);
        }
        if (entityData.primaryKey == null) {
            throw new IllegalStateException("No @PrimaryKey could be found for the @Entity " + entityClass.getCanonicalName());
        }
        ENTITY_DATA_CACHE.putIfAbsent(entityClass, entityData);
        return entityData;
    }

    public String toString() {
        return "EntityData for " + this.type.getCanonicalName();
    }
}

