/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb;

import java.lang.reflect.Field;
import org.droitateddb.EntityData;
import org.droitateddb.schema.AbstractAttribute;

public class Utilities {
    public static RuntimeException handle(Exception e) {
        if (e instanceof RuntimeException) {
            throw (RuntimeException)e;
        }
        throw new RuntimeException(e);
    }

    static void setFieldValue(Field field, Object data, Object value) {
        try {
            field.setAccessible(true);
            field.set(data, value);
        }
        catch (IllegalAccessException e) {
            throw Utilities.handle(e);
        }
    }

    static Object getFieldValue(Object data, Field field) {
        try {
            field.setAccessible(true);
            return field.get(data);
        }
        catch (IllegalAccessException e) {
            throw Utilities.handle(e);
        }
    }

    static String getLinkTableName(Class<?> linkTableSchema) {
        try {
            return (String)linkTableSchema.getDeclaredField("TABLE_NAME").get(null);
        }
        catch (Exception e) {
            throw Utilities.handle(e);
        }
    }

    static AbstractAttribute[] getLinkTableColumns(Class<?> linkTableSchema) {
        try {
            return (AbstractAttribute[])linkTableSchema.getDeclaredField("ATTRIBUTES").get(null);
        }
        catch (Exception e) {
            throw Utilities.handle(e);
        }
    }

    static String[] getLinkTableProjection(Class<?> linkTableSchema) {
        try {
            return (String[])linkTableSchema.getDeclaredField("PROJECTION").get(null);
        }
        catch (Exception e) {
            throw Utilities.handle(e);
        }
    }

    static Number getPrimaryKey(Object data, EntityData entityData) {
        return (Number)Utilities.getFieldValue(data, entityData.primaryKey);
    }
}

