/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb.builder.schema.reader;

import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.droitateddb.builder.schema.data.Schema;
import org.droitateddb.builder.schema.data.Table;
import org.droitateddb.builder.schema.reader.Reader;
import org.droitateddb.builder.schema.reader.TableReader;
import org.droitateddb.builder.schema.visitor.TypeResolvingVisitor;
import org.droitateddb.config.Persistence;

public class SchemaReader
implements Reader<Schema> {
    private final Persistence persistence;
    private final String updateHookClassName;
    private final String createHookClassName;
    private final Set<? extends Element> entities;
    private final Elements elements;
    private final Set<String> entityNames = new TreeSet<String>();
    private final Messager messager;

    public SchemaReader(Persistence persistence, String updateHookClassName, String createHookClassName, Set<? extends Element> entities, Elements elements, Messager messager) {
        this.persistence = persistence;
        this.updateHookClassName = updateHookClassName;
        this.createHookClassName = createHookClassName;
        this.entities = entities;
        this.elements = elements;
        for (Element element : entities) {
            this.entityNames.add(element.toString());
        }
        this.messager = messager;
    }

    @Override
    public Schema read() {
        Schema schema = new Schema(this.persistence.dbName(), this.persistence.dbVersion(), this.updateHookClassName, this.createHookClassName);
        for (Element element : this.entities) {
            TypeElement entity = element.accept(new TypeResolvingVisitor(), null);
            TableReader tableReader = new TableReader(entity, this.entityNames, this.elements, this.messager);
            Table read = tableReader.read();
            if (read == null) continue;
            schema.addTable(read);
        }
        return schema;
    }
}

