/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb.builder.schema.writer;

import java.util.Locale;
import org.droitateddb.builder.schema.data.Association;
import org.droitateddb.builder.schema.data.Table;
import org.droitateddb.builder.schema.writer.Writer;
import org.droitateddb.schema.AssociationType;

public class AssociationsInterfaceWriter
implements Writer {
    private final String indent;
    private final Table table;
    private final Association association;

    public AssociationsInterfaceWriter(String indent, Table table, Association association) {
        this.indent = indent;
        this.table = table;
        this.association = association;
    }

    @Override
    public String write() {
        StringBuilder builder = new StringBuilder();
        if (AssociationType.TO_ONE == this.association.getCardinality()) {
            String attributeRef = ("fk_" + this.association.getNameInEntity()).toUpperCase(Locale.getDefault());
            builder.append(this.indent).append("public static final ").append("ToOneAssociation ").append(this.association.getNameInEntity().toUpperCase(Locale.getDefault())).append(" = new ToOneAssociation(").append("\"").append(this.association.getNameInEntity()).append("\", ").append(this.association.getCanonicalTypeInEntity()).append(".class, ").append(attributeRef).append(");\n");
        } else if (AssociationType.TO_MANY == this.association.getCardinality()) {
            builder.append(this.indent).append("public static final ").append("ToManyAssociation ").append(this.association.getNameInEntity().toUpperCase(Locale.getDefault())).append(" = new ToManyAssociation(").append("\"").append(this.association.getNameInEntity()).append("\", ").append(this.association.getCanonicalTypeInEntity()).append(".class, ").append(this.table.getName() + this.association.getSimpleTypeInEntity() + "Association").append(".class);\n");
        }
        return builder.toString();
    }
}

