/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb.builder.schema.writer;

import java.util.Collection;
import java.util.HashSet;
import org.droitateddb.builder.schema.data.Association;
import org.droitateddb.builder.schema.data.Schema;
import org.droitateddb.builder.schema.data.Table;
import org.droitateddb.builder.schema.writer.EntityInfoWriter;
import org.droitateddb.builder.schema.writer.TableWriter;
import org.droitateddb.builder.schema.writer.ToManyAssociationWriter;
import org.droitateddb.builder.schema.writer.Writer;
import org.droitateddb.schema.AssociationType;
import org.droitateddb.util.Pair;

public class SchemaWriter
implements Writer {
    private final String packageName;
    private final String className;
    private final Schema schema;

    public SchemaWriter(String packageName, String className, Schema schema) {
        this.packageName = packageName;
        this.className = className;
        this.schema = schema;
    }

    @Override
    public String write() {
        StringBuilder builder = new StringBuilder();
        HashSet<Pair<String, String>> toNAssociations = new HashSet<Pair<String, String>>();
        this.addDeclaration(builder);
        this.addSchemaData(builder);
        this.addEntityInfos(builder);
        this.addTables(builder, toNAssociations);
        this.addToNAssociations(builder, toNAssociations);
        this.addEnd(builder);
        return builder.toString();
    }

    private void addDeclaration(StringBuilder builder) {
        builder.append("/** Automatically generated file. DO NOT MODIFY */\n");
        builder.append("package ").append(this.packageName).append(";\n\n");
        builder.append("import org.droitateddb.schema.*;\n\n");
        builder.append("public interface ").append(this.className).append(" {\n\n");
    }

    private void addSchemaData(StringBuilder builder) {
        builder.append("    ").append(String.format("public static final String %s = \"%s\";\n", "DB_NAME", this.schema.getDbName()));
        this.addHook(builder, "DB_CREATE_HOOK", this.schema.getCreateHookClassName());
        this.addHook(builder, "DB_UPDATE_HOOK", this.schema.getUpdateHookClassName());
        builder.append("    ").append(String.format("public static final int %s = %s;\n", "DB_VERSION", this.schema.getDbVersion()));
        builder.append("\n");
    }

    private void addHook(StringBuilder builder, String hookName, String hookClassName) {
        if (hookClassName != null && hookClassName.length() > 0) {
            builder.append("    ").append(String.format("public static final String %s = \"%s\";\n", hookName, hookClassName));
        }
    }

    private void addTables(StringBuilder builder, Collection<Pair<String, String>> toNAssociations) {
        for (Table table : this.schema.getTables()) {
            TableWriter tableWriter = new TableWriter("    ", table);
            builder.append(tableWriter.write());
            builder.append("\n");
            for (Association association : table.getAssociations()) {
                if (!association.getCardinality().equals((Object)AssociationType.TO_MANY)) continue;
                String tableType = table.getEntityClassName();
                String associatedType = association.getCanonicalTypeInEntity();
                toNAssociations.add(new Pair<String, String>(tableType, associatedType));
            }
        }
    }

    private void addEntityInfos(StringBuilder builder) {
        for (Table table : this.schema.getTables()) {
            EntityInfoWriter entityInfoWriter = new EntityInfoWriter("    ", table);
            builder.append(entityInfoWriter.write());
        }
        builder.append("\n");
    }

    private void addToNAssociations(StringBuilder builder, Collection<Pair<String, String>> toNAssociations) {
        for (Pair<String, String> link : toNAssociations) {
            ToManyAssociationWriter toManyAssociationWriter = new ToManyAssociationWriter("    ", link);
            builder.append(toManyAssociationWriter.write());
        }
    }

    private void addEnd(StringBuilder builder) {
        builder.append("}\n");
    }
}

