/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb.manifest;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.droitateddb.manifest.AndroidManifest;
import org.droitateddb.processor.ContentProviderData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AndroidManifestProcessor {
    private final File manifestFile;
    private final String generatedPackage;

    public AndroidManifestProcessor(File manifestFile, String generatedPackage) {
        this.manifestFile = manifestFile;
        this.generatedPackage = generatedPackage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AndroidManifest parse() throws Exception {
        FileInputStream manifestStream = new FileInputStream(this.manifestFile);
        try {
            Document document = AndroidManifestProcessor.createDocument(manifestStream);
            Element root = document.getDocumentElement();
            String usedPackage = root.getAttribute("package");
            AndroidManifest androidManifest = new AndroidManifest(usedPackage, this.findExistingContentProvider(root));
            return androidManifest;
        }
        finally {
            ((InputStream)manifestStream).close();
        }
    }

    private List<ContentProviderData> findExistingContentProvider(Element root) {
        NodeList nodesUnderApplication = AndroidManifestProcessor.getApplicationNodeFromRoot(root).getChildNodes();
        ArrayList<ContentProviderData> data = new ArrayList<ContentProviderData>(nodesUnderApplication.getLength());
        for (int i = 0; i < nodesUnderApplication.getLength(); ++i) {
            Node node = nodesUnderApplication.item(i);
            if (!node.getNodeName().equals("provider")) continue;
            NamedNodeMap attributes = node.getAttributes();
            String providerName = attributes.getNamedItem("android:name").getTextContent();
            String authority = attributes.getNamedItem("android:authorities").getTextContent();
            Node exportedAttribute = attributes.getNamedItem("android:exported");
            boolean exported = false;
            if (exportedAttribute != null) {
                exported = Boolean.parseBoolean(exportedAttribute.getTextContent());
            }
            data.add(new ContentProviderData(providerName, authority, exported));
        }
        return data;
    }

    private static Document createDocument(InputStream manifestStream) throws Exception {
        DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        return documentBuilder.parse(manifestStream);
    }

    private static Node getApplicationNodeFromRoot(Element root) {
        NodeList applicationTag = root.getElementsByTagName("application");
        if (applicationTag.getLength() != 1) {
            throw new IllegalStateException("Wrong number of application tags found within AndroidManifest.xml. There are " + applicationTag.getLength() + " tags");
        }
        return applicationTag.item(0);
    }

    public ManifestBuilder change() throws Exception {
        return new ManifestBuilder(this.manifestFile, this.parse(), this.generatedPackage);
    }

    public static final class ManifestBuilder {
        private final File manifestFile;
        private final LinkedList<ContentProviderData> addedProviders;
        private final AndroidManifest androidManifest;
        private final String generatedPackage;

        private ManifestBuilder(File manifestFile, AndroidManifest androidManifest, String generatedPackage) {
            this.manifestFile = manifestFile;
            this.androidManifest = androidManifest;
            this.generatedPackage = generatedPackage;
            this.addedProviders = new LinkedList();
        }

        public ManifestBuilder addProviderIfNotExists(ContentProviderData contentProviderData) {
            this.addedProviders.add(contentProviderData);
            return this;
        }

        public void commit() throws Exception {
            Document document = AndroidManifestProcessor.createDocument(new FileInputStream(this.manifestFile));
            Element root = document.getDocumentElement();
            Node application = AndroidManifestProcessor.getApplicationNodeFromRoot(root);
            boolean addedSomething = this.addProviderTagsIfNeeded(document, application);
            boolean removedSomething = this.removeUnusedProviders(application);
            this.saveToAndroidManifest(document, addedSomething || removedSomething);
        }

        private boolean addProviderTagsIfNeeded(Document document, Node application) {
            boolean changesSomething = false;
            for (ContentProviderData added : this.addedProviders) {
                if (!this.notContainedInProviderList(added, this.androidManifest.getContentProviders())) continue;
                Element newProvider = document.createElement("provider");
                newProvider.setAttribute("android:name", added.getCanonicalName());
                newProvider.setAttribute("android:authorities", added.getAuthority());
                newProvider.setAttribute("android:exported", Boolean.toString(added.isExported()));
                newProvider.setAttribute("droitateddb:generated", "true");
                application.appendChild(newProvider);
                document.getDocumentElement().setAttribute("xmlns:droitateddb", "http://droitateddb.org");
                changesSomething = true;
            }
            return changesSomething;
        }

        private boolean removeUnusedProviders(Node application) {
            boolean changedSomething = false;
            for (ContentProviderData inManifest : this.androidManifest.getContentProviders()) {
                if (!this.notContainedInProviderList(inManifest, this.addedProviders)) continue;
                changedSomething |= this.removeSingleProvider(inManifest, application);
            }
            return changedSomething;
        }

        private boolean removeSingleProvider(ContentProviderData inManifest, Node application) {
            NodeList applicationChildren = application.getChildNodes();
            for (int i = 0; i < applicationChildren.getLength(); ++i) {
                Node child = applicationChildren.item(i);
                if (!child.getNodeName().equals("provider") || !this.isGenerated(child)) continue;
                NamedNodeMap attributes = child.getAttributes();
                Node name = attributes.getNamedItem("android:name");
                Node authority = attributes.getNamedItem("android:authorities");
                if (!authority.getTextContent().equals(inManifest.getAuthority()) || !this.namesAreEqual(name.getTextContent(), inManifest.getCanonicalName())) continue;
                application.removeChild(child);
                return true;
            }
            return false;
        }

        private boolean notContainedInProviderList(ContentProviderData added, List<ContentProviderData> providers) {
            for (ContentProviderData inManifest : providers) {
                if (!inManifest.getAuthority().equals(added.getAuthority()) || !this.namesAreEqual(inManifest.getCanonicalName(), added.getCanonicalName()) || inManifest.isExported() != added.isExported()) continue;
                return false;
            }
            return true;
        }

        private boolean namesAreEqual(String providerName, String otherProviderName) {
            String comparableManifestName = this.packagedProviderName(providerName);
            String comparableProviderName = this.packagedProviderName(otherProviderName);
            return comparableManifestName.equals(comparableProviderName);
        }

        private String packagedProviderName(String name) {
            String packagedName = name.startsWith(".") ? this.generatedPackage + name : name;
            return packagedName;
        }

        private boolean isGenerated(Node child) {
            NamedNodeMap attributes = child.getAttributes();
            Node generated = attributes.getNamedItem("droitateddb:generated");
            if (generated == null) {
                return false;
            }
            return Boolean.parseBoolean(generated.getTextContent());
        }

        private void saveToAndroidManifest(Document document, boolean changedSomething) throws TransformerFactoryConfigurationError, TransformerConfigurationException, FileNotFoundException, TransformerException {
            if (changedSomething) {
                DOMSource source = new DOMSource(document);
                TransformerFactory transformerFactory = TransformerFactory.newInstance();
                Transformer transformer = transformerFactory.newTransformer();
                StreamResult result = new StreamResult(new FileOutputStream(this.manifestFile));
                transformer.transform(source, result);
            }
        }
    }
}

