/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb.processor;

import java.lang.annotation.Annotation;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.droitateddb.builder.provider.ContentProviderBuilder;
import org.droitateddb.builder.provider.SourceContentProviderData;
import org.droitateddb.builder.schema.reader.SchemaReader;
import org.droitateddb.builder.schema.visitor.TypeResolvingVisitor;
import org.droitateddb.builder.schema.writer.BasePackageConstantsWriter;
import org.droitateddb.builder.schema.writer.SchemaWriter;
import org.droitateddb.config.Persistence;
import org.droitateddb.entity.Entity;
import org.droitateddb.hooks.Create;
import org.droitateddb.hooks.DbCreate;
import org.droitateddb.hooks.DbUpdate;
import org.droitateddb.hooks.Update;
import org.droitateddb.manifest.AndroidManifest;
import org.droitateddb.manifest.AndroidManifestAccess;
import org.droitateddb.processor.ContentProviderData;
import org.droitateddb.processor.JavaFileWriter;

@SupportedAnnotationTypes(value={"org.droitateddb.entity.Entity", "org.droitateddb.config.Persistence", "org.droitateddb.hooks.Update", "org.droitateddb.hooks.Create"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class EntityAnnotationProcessor
extends AbstractProcessor {
    private Messager messager;
    private AndroidManifestAccess androidManifestAccess;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.androidManifestAccess = new AndroidManifestAccess(processingEnv);
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            try {
                Persistence persistence = this.checkPersistenceAnnotation(roundEnv);
                if (persistence == null) {
                    return true;
                }
                AndroidManifest androidManifest = this.androidManifestAccess.load();
                String basePackage = persistence.basePackage();
                if (basePackage == null || "".equals(basePackage)) {
                    basePackage = androidManifest.getPackageName();
                }
                String generatedPackage = basePackage + "." + "generated";
                this.messager.printMessage(Diagnostic.Kind.NOTE, "Use base package " + basePackage);
                this.androidManifestAccess.initGeneratedPackage(generatedPackage);
                String updateHookName = this.getHookName(roundEnv, Update.class, DbUpdate.class);
                String createHookName = this.getHookName(roundEnv, Create.class, DbCreate.class);
                Set<? extends Element> entityAnnotated = roundEnv.getElementsAnnotatedWith(Entity.class);
                this.generateDbSchema(generatedPackage, entityAnnotated, persistence, updateHookName, createHookName);
                this.generateContentProviderIfRequested(generatedPackage, entityAnnotated);
                this.generateBasePackageReference(basePackage);
            }
            catch (RuntimeException e) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Not able to generate DB schema from the annotated entity classes " + e.getMessage());
                throw e;
            }
            catch (Exception e) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Not able to generate DB schema from the annotated entity classes " + e.getMessage());
                throw new IllegalStateException(e);
            }
        }
        return true;
    }

    private void generateBasePackageReference(String basePackage) {
        JavaFileWriter javaFileWriter = new JavaFileWriter("org.droitateddb", "BasePackageReference", this.processingEnv);
        BasePackageConstantsWriter basePackageConstantsWriter = new BasePackageConstantsWriter(basePackage);
        javaFileWriter.write(basePackageConstantsWriter.write());
    }

    @Override
    public Set<String> getSupportedOptions() {
        HashSet<String> validOptions = new HashSet<String>();
        validOptions.add("manifest");
        return validOptions;
    }

    private Persistence checkPersistenceAnnotation(RoundEnvironment roundEnv) {
        Set<? extends Element> persistenceAnnotated = roundEnv.getElementsAnnotatedWith(Persistence.class);
        if (persistenceAnnotated.size() == 0) {
            return null;
        }
        if (persistenceAnnotated.size() > 1) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Only one @Persistence activator is allowed within the project", persistenceAnnotated.iterator().next());
            return null;
        }
        Element persistenceClass = persistenceAnnotated.iterator().next();
        return persistenceClass.getAnnotation(Persistence.class);
    }

    private String getHookName(RoundEnvironment roundEnv, Class<? extends Annotation> hookAnnotation, Class<?> hookInterface) {
        Set<? extends Element> annotated = roundEnv.getElementsAnnotatedWith(hookAnnotation);
        if (annotated.size() == 0) {
            return null;
        }
        if (annotated.size() > 1) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Only one " + hookAnnotation.getCanonicalName() + " hook is allowed with the project", annotated.iterator().next());
            return null;
        }
        Element updateElement = annotated.iterator().next();
        TypeElement typeElement = updateElement.accept(new TypeResolvingVisitor(), null);
        boolean implementsDbUpdate = false;
        for (TypeMirror typeMirror : typeElement.getInterfaces()) {
            if (!typeMirror.toString().equals(hookInterface.getCanonicalName())) continue;
            implementsDbUpdate = true;
        }
        if (!implementsDbUpdate) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "The " + hookAnnotation + " hook has to implement the " + hookInterface.getCanonicalName() + " interface", updateElement);
            return null;
        }
        return typeElement.getQualifiedName().toString();
    }

    private void generateDbSchema(String packageName, Set<? extends Element> entityAnnotated, Persistence persistence, String updateHookName, String createHookName) {
        SchemaReader schemaReader = new SchemaReader(persistence, updateHookName, createHookName, entityAnnotated, this.processingEnv.getElementUtils(), this.messager);
        SchemaWriter schemaWriter = new SchemaWriter(packageName, "DB", schemaReader.read());
        JavaFileWriter javaFileWriter = new JavaFileWriter(packageName, "DB", this.processingEnv);
        javaFileWriter.write(schemaWriter.write());
    }

    private void generateContentProviderIfRequested(String packageName, Set<? extends Element> entityAnnotated) throws Exception {
        LinkedList<ContentProviderData> providers = new LinkedList<ContentProviderData>();
        for (Element element : entityAnnotated) {
            Entity entityAnnotation = element.getAnnotation(Entity.class);
            if (!entityAnnotation.contentProvider()) continue;
            ContentProviderBuilder providerBuilder = new ContentProviderBuilder(packageName, element, this.messager);
            SourceContentProviderData providerData = providerBuilder.build();
            JavaFileWriter javaFileWriter = new JavaFileWriter(packageName, providerData.getSimpleName(), this.processingEnv);
            javaFileWriter.write(providerData.getSource());
            providers.add(providerData);
        }
        this.androidManifestAccess.addProviders(providers);
    }

    public static void main(String[] args) {
    }
}

