/*
 * Decompiled with CFR 0.152.
 */
package org.droitateddb.validation;

import java.math.BigDecimal;
import org.droitateddb.validation.CustomValidator;
import org.droitateddb.validation.Min;
import org.droitateddb.validation.ValidationResult;

public class MinValidator
implements CustomValidator<Min, Number> {
    public static final int ERROR_CODE = 2;

    @Override
    public ValidationResult onValidate(Min annotation, Number toByValidated) {
        long min = annotation.value();
        if (toByValidated == null) {
            return ValidationResult.valid();
        }
        if (new BigDecimal(toByValidated.toString()).compareTo(new BigDecimal(min)) >= 0) {
            return ValidationResult.valid();
        }
        return ValidationResult.invalid(2, "The field as to be greater or equal to " + min);
    }
}

