/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy;

import java.lang.reflect.ParameterizedType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lombok.NonNull;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.RunMode;
import org.dromara.autotable.core.converter.DefaultTypeEnumInterface;
import org.dromara.autotable.core.dynamicds.SqlSessionFactoryManager;
import org.dromara.autotable.core.recordsql.AutoTableExecuteSqlLog;
import org.dromara.autotable.core.recordsql.RecordSqlService;
import org.dromara.autotable.core.strategy.CompareTableInfo;
import org.dromara.autotable.core.strategy.TableMetadata;
import org.dromara.autotable.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IStrategy<TABLE_META extends TableMetadata, COMPARE_TABLE_INFO extends CompareTableInfo, MAPPER> {
    public static final Logger log = LoggerFactory.getLogger(IStrategy.class);

    default public <R> R executeReturn(Function<MAPPER, R> execute) {
        Class<MAPPER> mapperClass = this.getMapperClass();
        try (SqlSession sqlSession = SqlSessionFactoryManager.getSqlSessionFactory().openSession();){
            R r = execute.apply(sqlSession.getMapper(mapperClass));
            return r;
        }
    }

    default public Class<MAPPER> getMapperClass() {
        ParameterizedType genericSuperclass = (ParameterizedType)this.getClass().getGenericInterfaces()[0];
        Class mapperClass = (Class)genericSuperclass.getActualTypeArguments()[2];
        SqlSessionFactory sqlSessionFactory = SqlSessionFactoryManager.getSqlSessionFactory();
        Configuration configuration = sqlSessionFactory.getConfiguration();
        if (!configuration.hasMapper(mapperClass)) {
            configuration.addMapper(mapperClass);
        }
        return mapperClass;
    }

    default public void start(Class<?> entityClass) {
        AutoTableGlobalConfig.getRunStateCallback().before(entityClass);
        TABLE_META tableMetadata = this.analyseClass(entityClass);
        this.start(tableMetadata);
        AutoTableGlobalConfig.getRunStateCallback().after(entityClass);
    }

    default public void start(TABLE_META tableMetadata) {
        AutoTableGlobalConfig.getBuildTableMetadataInterceptor().intercept(this.databaseDialect(), (TableMetadata)tableMetadata);
        RunMode runMode = AutoTableGlobalConfig.getAutoTableProperties().getMode();
        switch (runMode) {
            case validate: {
                this.validateMode(tableMetadata);
                break;
            }
            case create: {
                this.createMode(tableMetadata);
                break;
            }
            case update: {
                this.updateMode(tableMetadata);
                break;
            }
            default: {
                throw new RuntimeException(String.format("\u4e0d\u652f\u6301\u7684\u8fd0\u884c\u6a21\u5f0f\uff1a%s", new Object[]{runMode}));
            }
        }
    }

    default public void validateMode(TABLE_META tableMetadata) {
        String tableName;
        String schema = ((TableMetadata)tableMetadata).getSchema();
        boolean tableNotExist = this.checkTableNotExist(schema, tableName = ((TableMetadata)tableMetadata).getTableName());
        if (tableNotExist) {
            AutoTableGlobalConfig.getValidateFinishCallback().validateFinish(false, this.databaseDialect(), null);
            throw new RuntimeException(String.format("\u542f\u52a8\u5931\u8d25\uff0c%s\u4e2d\u4e0d\u5b58\u5728\u8868%s", this.databaseDialect(), ((TableMetadata)tableMetadata).getTableName()));
        }
        COMPARE_TABLE_INFO compareTableInfo = this.compareTable(tableMetadata);
        if (((CompareTableInfo)compareTableInfo).needModify()) {
            log.warn("{}\u8868\u7ed3\u6784\u4e0d\u4e00\u81f4\uff1a\n{}", (Object)((TableMetadata)tableMetadata).getTableName(), (Object)((CompareTableInfo)compareTableInfo).validateFailedMessage());
            AutoTableGlobalConfig.getValidateFinishCallback().validateFinish(false, this.databaseDialect(), (CompareTableInfo)compareTableInfo);
            throw new RuntimeException(String.format("\u542f\u52a8\u5931\u8d25\uff0c%s\u6570\u636e\u8868%s\u4e0e\u5b9e\u4f53\u4e0d\u5339\u914d", this.databaseDialect(), ((TableMetadata)tableMetadata).getTableName()));
        }
        AutoTableGlobalConfig.getValidateFinishCallback().validateFinish(true, this.databaseDialect(), (CompareTableInfo)compareTableInfo);
    }

    default public void createMode(TABLE_META tableMetadata) {
        String schema = ((TableMetadata)tableMetadata).getSchema();
        String tableName = ((TableMetadata)tableMetadata).getTableName();
        log.info("create\u6a21\u5f0f\uff0c\u5220\u9664\u8868\uff1a{}", (Object)tableName);
        String sql = this.dropTable(schema, tableName);
        this.executeSql(tableMetadata, Collections.singletonList(sql));
        this.executeCreateTable(tableMetadata);
    }

    default public void updateMode(TABLE_META tableMetadata) {
        String tableName;
        String schema = ((TableMetadata)tableMetadata).getSchema();
        boolean tableNotExist = this.checkTableNotExist(schema, tableName = ((TableMetadata)tableMetadata).getTableName());
        if (tableNotExist) {
            this.executeCreateTable(tableMetadata);
            return;
        }
        COMPARE_TABLE_INFO compareTableInfo = this.compareTable(tableMetadata);
        if (((CompareTableInfo)compareTableInfo).needModify()) {
            log.info("\u4fee\u6539\u8868\uff1a{}", (Object)((StringUtils.hasText(schema) ? schema + "." : "") + tableName));
            AutoTableGlobalConfig.getModifyTableInterceptor().beforeModifyTable(this.databaseDialect(), (TableMetadata)tableMetadata, (CompareTableInfo)compareTableInfo);
            List<String> sqlList = this.modifyTable(compareTableInfo);
            this.executeSql(tableMetadata, sqlList);
            AutoTableGlobalConfig.getModifyTableFinishCallback().afterModifyTable(this.databaseDialect(), (TableMetadata)tableMetadata, (CompareTableInfo)compareTableInfo);
        }
    }

    default public void executeCreateTable(TABLE_META tableMetadata) {
        String schema = ((TableMetadata)tableMetadata).getSchema();
        String tableName = ((TableMetadata)tableMetadata).getTableName();
        log.info("\u521b\u5efa\u8868\uff1a{}", (Object)((StringUtils.hasText(schema) ? schema + "." : "") + tableName));
        AutoTableGlobalConfig.getCreateTableInterceptor().beforeCreateTable(this.databaseDialect(), (TableMetadata)tableMetadata);
        List<String> sqlList = this.createTable(tableMetadata);
        this.executeSql(tableMetadata, sqlList);
        AutoTableGlobalConfig.getCreateTableFinishCallback().afterCreateTable(this.databaseDialect(), (TableMetadata)tableMetadata);
    }

    default public void executeSql(TABLE_META tableMetadata, List<String> sqlList) {
        SqlSessionFactory sqlSessionFactory = SqlSessionFactoryManager.getSqlSessionFactory();
        try (SqlSession sqlSession = sqlSessionFactory.openSession();
             Connection connection = sqlSession.getConnection();){
            log.debug("\u5f00\u542f\u4e8b\u52a1");
            connection.setAutoCommit(false);
            ArrayList<AutoTableExecuteSqlLog> autoTableExecuteSqlLogs = new ArrayList<AutoTableExecuteSqlLog>();
            try (Statement statement = connection.createStatement();){
                for (String sql : sqlList) {
                    if (!sql.endsWith(";")) {
                        sql = sql + ";";
                    }
                    long executionTime = System.currentTimeMillis();
                    statement.execute(sql);
                    long executionEndTime = System.currentTimeMillis();
                    AutoTableExecuteSqlLog autoTableExecuteSqlLog = AutoTableExecuteSqlLog.of(((TableMetadata)tableMetadata).getEntityClass(), ((TableMetadata)tableMetadata).getSchema(), ((TableMetadata)tableMetadata).getTableName(), sql, executionTime, executionEndTime);
                    autoTableExecuteSqlLogs.add(autoTableExecuteSqlLog);
                    log.info("\u6267\u884csql({}ms)\uff1a{}", (Object)(executionEndTime - executionTime), (Object)sql);
                }
                log.debug("\u63d0\u4ea4\u4e8b\u52a1");
                connection.commit();
            }
            catch (Exception e) {
                connection.rollback();
                throw new RuntimeException(String.format("\u6267\u884cSQL: \n%s\n\u671f\u95f4\u51fa\u9519", String.join((CharSequence)"\n", sqlList)), e);
            }
            RecordSqlService.record(autoTableExecuteSqlLogs);
        }
        catch (SQLException e) {
            throw new RuntimeException("\u83b7\u53d6\u6570\u636e\u5e93\u8fde\u63a5\u51fa\u9519", e);
        }
    }

    default public boolean checkTableNotExist(String schema, String tableName) {
        boolean bl;
        block8: {
            Configuration configuration = SqlSessionFactoryManager.getSqlSessionFactory().getConfiguration();
            Connection connection = configuration.getEnvironment().getDataSource().getConnection();
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                String connectionCatalog = connection.getCatalog();
                String connectionSchema = connection.getSchema();
                boolean exist = metaData.getTables(connectionCatalog, StringUtils.hasText(schema) ? schema : connectionSchema, tableName, new String[]{"TABLE"}).next();
                boolean bl2 = bl = !exist;
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("\u5224\u65ad\u6570\u636e\u5e93\u662f\u5426\u5b58\u5728\u51fa\u9519", e);
                }
            }
            connection.close();
        }
        return bl;
    }

    default public List<String> createTable(Class<?> clazz) {
        TABLE_META tableMeta = this.analyseClass(clazz);
        return this.createTable(tableMeta);
    }

    public String databaseDialect();

    public Map<Class<?>, DefaultTypeEnumInterface> typeMapping();

    public String dropTable(String var1, String var2);

    @NonNull
    public TABLE_META analyseClass(Class<?> var1);

    public List<String> createTable(TABLE_META var1);

    @NonNull
    public COMPARE_TABLE_INFO compareTable(TABLE_META var1);

    public List<String> modifyTable(COMPARE_TABLE_INFO var1);
}

