/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy.pgsql.builder;

import org.dromara.autotable.annotation.enums.DefaultValueEnum;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.utils.StringConnectHelper;
import org.dromara.autotable.core.utils.StringUtils;

public class ColumnSqlBuilder {
    public static String buildSql(ColumnMetadata columnMetadata) {
        return StringConnectHelper.newInstance("{columnName} {typeAndLength} {null} {default}").replace("{columnName}", columnMetadata.getName()).replace("{typeAndLength}", () -> {
            if (columnMetadata.isAutoIncrement()) {
                return "serial";
            }
            return columnMetadata.getType().getDefaultFullType();
        }).replace("{null}", columnMetadata.isNotNull() ? "NOT NULL" : "").replace("{default}", () -> {
            DefaultValueEnum defaultValueType = columnMetadata.getDefaultValueType();
            if (defaultValueType == DefaultValueEnum.NULL) {
                return "DEFAULT NULL";
            }
            if (defaultValueType == DefaultValueEnum.EMPTY_STRING) {
                return "DEFAULT ''";
            }
            String defaultValue = columnMetadata.getDefaultValue();
            if (DefaultValueEnum.isCustom((DefaultValueEnum)defaultValueType) && StringUtils.hasText(defaultValue)) {
                return "DEFAULT " + defaultValue;
            }
            return "";
        }).toString();
    }
}

