/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy.pgsql.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dromara.autotable.annotation.enums.DefaultValueEnum;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.strategy.pgsql.PgsqlStrategy;
import org.dromara.autotable.core.strategy.pgsql.builder.ColumnSqlBuilder;
import org.dromara.autotable.core.strategy.pgsql.builder.CreateTableSqlBuilder;
import org.dromara.autotable.core.strategy.pgsql.data.PgsqlCompareTableInfo;
import org.dromara.autotable.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModifyTableSqlBuilder {
    private static final Logger log = LoggerFactory.getLogger(ModifyTableSqlBuilder.class);

    public static String buildSql(PgsqlCompareTableInfo pgsqlCompareTableInfo) {
        String tableName = pgsqlCompareTableInfo.getName();
        String schema = pgsqlCompareTableInfo.getSchema();
        String tableComment = pgsqlCompareTableInfo.getComment();
        Map<String, String> columnComment = pgsqlCompareTableInfo.getColumnComment();
        Map<String, String> indexComment = pgsqlCompareTableInfo.getIndexComment();
        ArrayList<String> alterTableSqlList = new ArrayList<String>();
        String primaryKeyName = pgsqlCompareTableInfo.getDropPrimaryKeyName();
        if (StringUtils.hasText(primaryKeyName)) {
            alterTableSqlList.add("  DROP CONSTRAINT " + primaryKeyName);
        }
        List<String> dropColumnList = pgsqlCompareTableInfo.getDropColumnList();
        dropColumnList.stream().map(columnName -> "  DROP COLUMN " + columnName).forEach(alterTableSqlList::add);
        List<ColumnMetadata> newColumnList = pgsqlCompareTableInfo.getNewColumnMetadataList();
        newColumnList.stream().map(column -> "  ADD COLUMN " + ColumnSqlBuilder.buildSql(column)).forEach(alterTableSqlList::add);
        List<ColumnMetadata> modifyColumnList = pgsqlCompareTableInfo.getModifyColumnMetadataList();
        for (ColumnMetadata columnMetadata : modifyColumnList) {
            String columnName2 = columnMetadata.getName();
            alterTableSqlList.add("  ALTER COLUMN " + columnName2 + " TYPE " + columnMetadata.getType().getDefaultFullType());
            alterTableSqlList.add("  ALTER COLUMN " + columnName2 + " " + (columnMetadata.isNotNull() ? "SET" : "DROP") + " NOT NULL");
            String defaultVal = null;
            DefaultValueEnum defaultValueType = columnMetadata.getDefaultValueType();
            if (DefaultValueEnum.EMPTY_STRING == defaultValueType) {
                defaultVal = "''";
            } else if (DefaultValueEnum.NULL == defaultValueType) {
                defaultVal = "NULL";
            } else {
                String defaultValue = columnMetadata.getDefaultValue();
                if (StringUtils.hasText(defaultValue)) {
                    defaultVal = defaultValue;
                }
            }
            if (StringUtils.hasText(defaultVal)) {
                alterTableSqlList.add("  ALTER COLUMN " + columnName2 + " SET DEFAULT " + defaultVal);
                continue;
            }
            alterTableSqlList.add("  ALTER COLUMN " + columnName2 + " DROP DEFAULT");
        }
        List<ColumnMetadata> newPrimaries = pgsqlCompareTableInfo.getNewPrimaries();
        if (!newPrimaries.isEmpty()) {
            String primaryColumns = newPrimaries.stream().map(ColumnMetadata::getName).collect(Collectors.joining(", "));
            if (StringUtils.hasText(primaryKeyName)) {
                alterTableSqlList.add("  ADD CONSTRAINT " + primaryKeyName + " PRIMARY KEY (" + primaryColumns + ")");
            } else {
                alterTableSqlList.add("  ADD PRIMARY KEY (" + primaryColumns + ")");
            }
        }
        String alterTableSql = "";
        if (!alterTableSqlList.isEmpty()) {
            alterTableSql = "ALTER TABLE " + PgsqlStrategy.withSchemaName(schema, tableName) + " \n" + String.join((CharSequence)",\n", alterTableSqlList) + ";";
        }
        String addColumnCommentSql = CreateTableSqlBuilder.getAddColumnCommentSql(schema, tableName, tableComment, columnComment, indexComment);
        List<String> dropIndexList = pgsqlCompareTableInfo.getDropIndexList();
        String dropIndexSql = dropIndexList.stream().map(indexName -> "DROP INDEX " + PgsqlStrategy.withSchemaName(schema, indexName) + ";").collect(Collectors.joining("\n"));
        String createIndexSql = CreateTableSqlBuilder.getCreateIndexSql(schema, tableName, pgsqlCompareTableInfo.getIndexMetadataList());
        return Stream.of(dropIndexSql, alterTableSql, addColumnCommentSql, createIndexSql).filter(StringUtils::hasText).collect(Collectors.joining("\n"));
    }
}

