/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy.pgsql.data;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.strategy.CompareTableInfo;
import org.dromara.autotable.core.strategy.IndexMetadata;
import org.dromara.autotable.core.utils.StringUtils;

public class PgsqlCompareTableInfo
extends CompareTableInfo {
    private String comment;
    private List<ColumnMetadata> newPrimaries = new ArrayList<ColumnMetadata>();
    private String dropPrimaryKeyName;
    private Map<String, String> columnComment = new HashMap<String, String>();
    private Map<String, String> indexComment = new HashMap<String, String>();
    private List<String> dropColumnList = new ArrayList<String>();
    private List<ColumnMetadata> modifyColumnMetadataList = new ArrayList<ColumnMetadata>();
    private List<ColumnMetadata> newColumnMetadataList = new ArrayList<ColumnMetadata>();
    private List<String> dropIndexList = new ArrayList<String>();
    private List<IndexMetadata> indexMetadataList = new ArrayList<IndexMetadata>();

    public PgsqlCompareTableInfo(@NonNull String name, @NonNull String schema) {
        super(name, schema);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
    }

    @Override
    public boolean needModify() {
        return StringUtils.hasText(this.comment) || StringUtils.hasText(this.dropPrimaryKeyName) || !this.newPrimaries.isEmpty() || !this.columnComment.isEmpty() || !this.indexComment.isEmpty() || !this.dropColumnList.isEmpty() || !this.modifyColumnMetadataList.isEmpty() || !this.newColumnMetadataList.isEmpty() || !this.dropIndexList.isEmpty() || !this.indexMetadataList.isEmpty();
    }

    @Override
    public String validateFailedMessage() {
        StringBuilder errorMsg = new StringBuilder();
        if (StringUtils.hasText(this.comment)) {
            errorMsg.append("\u8868\u6ce8\u91ca\u53d8\u66f4: ").append(this.comment).append("\n");
        }
        if (StringUtils.hasText(this.dropPrimaryKeyName)) {
            errorMsg.append("\u5220\u9664\u4e3b\u952e: ").append(this.dropPrimaryKeyName).append("\n");
        }
        if (!this.newPrimaries.isEmpty()) {
            errorMsg.append("\u65b0\u589e\u4e3b\u952e: ").append(this.newPrimaries).append("\n");
        }
        if (!this.columnComment.isEmpty()) {
            errorMsg.append("\u5217\u6ce8\u91ca\u53d8\u66f4: ").append(this.columnComment.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + (String)entry.getValue()).collect(Collectors.joining(", "))).append("\n");
        }
        if (!this.indexComment.isEmpty()) {
            errorMsg.append("\u7d22\u5f15\u6ce8\u91ca\u53d8\u66f4: ").append(this.indexComment.entrySet().stream().map(entry -> (String)entry.getKey() + ":" + (String)entry.getValue()).collect(Collectors.joining(", "))).append("\n");
        }
        if (!this.dropColumnList.isEmpty()) {
            errorMsg.append("\u5220\u9664\u5217: ").append(String.join((CharSequence)",", this.dropColumnList)).append("\n");
        }
        if (!this.modifyColumnMetadataList.isEmpty()) {
            errorMsg.append("\u4fee\u6539\u5217: ").append(this.modifyColumnMetadataList.stream().map(ColumnMetadata::getName).collect(Collectors.joining(","))).append("\n");
        }
        if (!this.newColumnMetadataList.isEmpty()) {
            errorMsg.append("\u65b0\u589e\u5217: ").append(this.newColumnMetadataList.stream().map(ColumnMetadata::getName).collect(Collectors.joining(","))).append("\n");
        }
        if (!this.dropIndexList.isEmpty()) {
            errorMsg.append("\u5220\u9664\u7d22\u5f15: ").append(String.join((CharSequence)",", this.dropIndexList)).append("\n");
        }
        if (!this.indexMetadataList.isEmpty()) {
            errorMsg.append("\u65b0\u589e\u7d22\u5f15: ").append(this.indexMetadataList.stream().map(IndexMetadata::getName).collect(Collectors.joining(","))).append("\n");
        }
        return errorMsg.toString();
    }

    public void addColumnComment(String columnName, String newComment) {
        this.columnComment.put(columnName, newComment);
    }

    public void addNewColumn(ColumnMetadata columnMetadata) {
        this.newColumnMetadataList.add(columnMetadata);
    }

    public void addModifyColumn(ColumnMetadata columnMetadata) {
        this.modifyColumnMetadataList.add(columnMetadata);
    }

    public void addDropColumns(Set<String> dropColumnList) {
        this.dropColumnList.addAll(dropColumnList);
    }

    public void addNewIndex(IndexMetadata indexMetadata) {
        this.indexMetadataList.add(indexMetadata);
    }

    public void addModifyIndex(IndexMetadata indexMetadata) {
        this.dropIndexList.add(indexMetadata.getName());
        this.indexMetadataList.add(indexMetadata);
    }

    public void addIndexComment(@NonNull String indexName, @NonNull String newComment) {
        if (indexName == null) {
            throw new NullPointerException("indexName is marked non-null but is null");
        }
        if (newComment == null) {
            throw new NullPointerException("newComment is marked non-null but is null");
        }
        this.indexComment.put(indexName, newComment);
    }

    public void addDropIndexes(Set<String> indexNameList) {
        this.dropIndexList.addAll(indexNameList);
    }

    public void addNewPrimary(List<ColumnMetadata> columnMetadata) {
        this.newPrimaries.addAll(columnMetadata);
    }

    public String getComment() {
        return this.comment;
    }

    public List<ColumnMetadata> getNewPrimaries() {
        return this.newPrimaries;
    }

    public String getDropPrimaryKeyName() {
        return this.dropPrimaryKeyName;
    }

    public Map<String, String> getColumnComment() {
        return this.columnComment;
    }

    public Map<String, String> getIndexComment() {
        return this.indexComment;
    }

    public List<String> getDropColumnList() {
        return this.dropColumnList;
    }

    public List<ColumnMetadata> getModifyColumnMetadataList() {
        return this.modifyColumnMetadataList;
    }

    public List<ColumnMetadata> getNewColumnMetadataList() {
        return this.newColumnMetadataList;
    }

    public List<String> getDropIndexList() {
        return this.dropIndexList;
    }

    public List<IndexMetadata> getIndexMetadataList() {
        return this.indexMetadataList;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public void setNewPrimaries(List<ColumnMetadata> newPrimaries) {
        this.newPrimaries = newPrimaries;
    }

    public void setDropPrimaryKeyName(String dropPrimaryKeyName) {
        this.dropPrimaryKeyName = dropPrimaryKeyName;
    }

    public void setColumnComment(Map<String, String> columnComment) {
        this.columnComment = columnComment;
    }

    public void setIndexComment(Map<String, String> indexComment) {
        this.indexComment = indexComment;
    }

    public void setDropColumnList(List<String> dropColumnList) {
        this.dropColumnList = dropColumnList;
    }

    public void setModifyColumnMetadataList(List<ColumnMetadata> modifyColumnMetadataList) {
        this.modifyColumnMetadataList = modifyColumnMetadataList;
    }

    public void setNewColumnMetadataList(List<ColumnMetadata> newColumnMetadataList) {
        this.newColumnMetadataList = newColumnMetadataList;
    }

    public void setDropIndexList(List<String> dropIndexList) {
        this.dropIndexList = dropIndexList;
    }

    public void setIndexMetadataList(List<IndexMetadata> indexMetadataList) {
        this.indexMetadataList = indexMetadataList;
    }
}

