/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy.sqlite.data;

import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.dromara.autotable.core.strategy.CompareTableInfo;

public class SqliteCompareTableInfo
extends CompareTableInfo {
    private String rebuildTableSql;
    private List<String> buildIndexSqlList = new ArrayList<String>();
    private List<String> deleteIndexList = new ArrayList<String>();

    public SqliteCompareTableInfo(@NonNull String name, @NonNull String schema) {
        super(name, schema);
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (schema == null) {
            throw new NullPointerException("schema is marked non-null but is null");
        }
    }

    @Override
    public boolean needModify() {
        return this.rebuildTableSql != null || !this.buildIndexSqlList.isEmpty() || !this.deleteIndexList.isEmpty();
    }

    @Override
    public String validateFailedMessage() {
        StringBuilder errorMsg = new StringBuilder();
        if (this.rebuildTableSql != null) {
            errorMsg.append("\u65b0\u7684\u5efa\u8868\u8bed\u53e5: ").append(this.rebuildTableSql).append("\n");
        }
        if (!this.deleteIndexList.isEmpty()) {
            errorMsg.append("\u5f85\u5220\u9664\u7684\u7d22\u5f15: ").append(String.join((CharSequence)",", this.deleteIndexList)).append("\n");
        }
        if (!this.buildIndexSqlList.isEmpty()) {
            errorMsg.append("\u65b0\u589e\u7684\u7d22\u5f15: ").append(String.join((CharSequence)",", this.buildIndexSqlList)).append("\n");
        }
        return errorMsg.toString();
    }

    public String getRebuildTableSql() {
        return this.rebuildTableSql;
    }

    public List<String> getBuildIndexSqlList() {
        return this.buildIndexSqlList;
    }

    public List<String> getDeleteIndexList() {
        return this.deleteIndexList;
    }

    public void setRebuildTableSql(String rebuildTableSql) {
        this.rebuildTableSql = rebuildTableSql;
    }

    public void setBuildIndexSqlList(List<String> buildIndexSqlList) {
        this.buildIndexSqlList = buildIndexSqlList;
    }

    public void setDeleteIndexList(List<String> deleteIndexList) {
        this.deleteIndexList = deleteIndexList;
    }

    public static class RebuildIndex {
        private String name;
        private String sql;

        public String getName() {
            return this.name;
        }

        public String getSql() {
            return this.sql;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setSql(String sql) {
            this.sql = sql;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof RebuildIndex)) {
                return false;
            }
            RebuildIndex other = (RebuildIndex)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$sql = this.getSql();
            String other$sql = other.getSql();
            return !(this$sql == null ? other$sql != null : !this$sql.equals(other$sql));
        }

        protected boolean canEqual(Object other) {
            return other instanceof RebuildIndex;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $sql = this.getSql();
            result = result * 59 + ($sql == null ? 43 : $sql.hashCode());
            return result;
        }

        public String toString() {
            return "SqliteCompareTableInfo.RebuildIndex(name=" + this.getName() + ", sql=" + this.getSql() + ")";
        }

        public RebuildIndex(String name, String sql) {
            this.name = name;
            this.sql = sql;
        }
    }
}

