/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.builder;

import java.lang.reflect.Field;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.dromara.autotable.annotation.Index;
import org.dromara.autotable.annotation.IndexField;
import org.dromara.autotable.annotation.TableIndex;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.strategy.IndexMetadata;
import org.dromara.autotable.core.utils.IndexRepeatChecker;
import org.dromara.autotable.core.utils.StringUtils;
import org.dromara.autotable.core.utils.TableBeanUtils;

public class IndexMetadataBuilder {
    public <T extends IndexMetadata> List<T> buildList(Class<?> clazz, List<Field> fields) {
        IndexRepeatChecker indexRepeatChecker = IndexRepeatChecker.of();
        ArrayList<IndexMetadata> indexMetadataList = new ArrayList<IndexMetadata>(16);
        List<IndexMetadata> onClassIndexMetadata = this.buildFromClass(clazz, indexRepeatChecker);
        indexMetadataList.addAll(onClassIndexMetadata);
        List<IndexMetadata> onFieldIndexMetadata = this.buildFromField(clazz, fields, indexRepeatChecker);
        indexMetadataList.addAll(onFieldIndexMetadata);
        return indexMetadataList;
    }

    protected List<IndexMetadata> buildFromField(Class<?> clazz, List<Field> fields, IndexRepeatChecker indexRepeatChecker) {
        return fields.stream().filter(field -> TableBeanUtils.isIncludeField(field, clazz)).map(field -> this.buildIndexMetadata(clazz, (Field)field)).filter(Objects::nonNull).peek(indexMetadata -> indexRepeatChecker.filter(indexMetadata.getName())).collect(Collectors.toList());
    }

    protected List<IndexMetadata> buildFromClass(Class<?> clazz, IndexRepeatChecker indexRepeatChecker) {
        List<TableIndex> tableIndexes = TableBeanUtils.getTableIndexes(clazz);
        return tableIndexes.stream().map(tableIndex -> this.buildIndexMetadata(clazz, (TableIndex)tableIndex)).filter(Objects::nonNull).peek(indexMetadata -> indexRepeatChecker.filter(indexMetadata.getName())).collect(Collectors.toList());
    }

    protected IndexMetadata buildIndexMetadata(Class<?> clazz, Field field) {
        Index index = TableBeanUtils.getIndex(field);
        if (null != index) {
            String realColumnName = TableBeanUtils.getRealColumnName(clazz, field);
            IndexMetadata indexMetadata = this.newIndexMetadata();
            String indexName = this.getIndexName(clazz, field, index);
            indexMetadata.setName(indexName);
            indexMetadata.setType(index.type());
            indexMetadata.setComment(index.comment());
            indexMetadata.getColumns().add(IndexMetadata.IndexColumnParam.newInstance(realColumnName, null));
            return indexMetadata;
        }
        return null;
    }

    protected String getIndexName(Class<?> clazz, TableIndex tableIndex) {
        String indexPrefix = AutoTableGlobalConfig.getAutoTableProperties().getIndexPrefix();
        String indexName = tableIndex.name();
        if (StringUtils.hasText(indexName)) {
            return indexPrefix + indexName;
        }
        String filedNames = Stream.concat(Arrays.stream(tableIndex.indexFields()).map(IndexField::field), Arrays.stream(tableIndex.fields())).map(fieldName -> TableBeanUtils.getRealColumnName(clazz, fieldName)).collect(Collectors.joining("_"));
        String tableName = TableBeanUtils.getTableName(clazz);
        return this.encryptIndexName(indexPrefix, tableName, filedNames);
    }

    protected String getIndexName(Class<?> clazz, Field field, Index index) {
        String indexPrefix = AutoTableGlobalConfig.getAutoTableProperties().getIndexPrefix();
        String indexName = index.name();
        if (StringUtils.hasText(indexName)) {
            return indexPrefix + indexName;
        }
        String realColumnName = this.getDefaultIndexName(clazz, field);
        String tableName = TableBeanUtils.getTableName(clazz);
        return this.encryptIndexName(indexPrefix, tableName, realColumnName);
    }

    protected String getDefaultIndexName(Class<?> clazz, Field field) {
        return TableBeanUtils.getRealColumnName(clazz, field);
    }

    protected String encryptIndexName(String prefix, String tableNamePart, String filedNamePart) {
        String indexName = prefix + tableNamePart + "_" + filedNamePart;
        int maxLength = 63;
        if (indexName.length() > maxLength) {
            String md5 = this.generateMD5(indexName);
            if (prefix.length() + md5.length() > maxLength) {
                throw new RuntimeException("\u7d22\u5f15\u540d\u524d\u7f00[" + prefix + "]\u8d85\u957f\uff0c\u65e0\u6cd5\u751f\u6210\u6709\u6548\u7d22\u5f15\u540d\u79f0\uff0c\u8bf7\u624b\u52a8\u6307\u5b9a\u7d22\u5f15\u540d\u79f0");
            }
            String onePart = indexName.substring(0, maxLength - md5.length());
            return onePart + md5;
        }
        return indexName;
    }

    private String generateMD5(String text) {
        MessageDigest md = MessageDigest.getInstance("MD5");
        byte[] hashBytes = md.digest(text.getBytes());
        StringBuilder sb = new StringBuilder();
        for (byte b : hashBytes) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }

    protected IndexMetadata buildIndexMetadata(Class<?> clazz, TableIndex tableIndex) {
        if (null != tableIndex && (tableIndex.fields().length > 0 || tableIndex.indexFields().length > 0)) {
            List<IndexMetadata.IndexColumnParam> columnParams = this.getColumnParams(clazz, tableIndex);
            IndexMetadata indexMetadata = this.newIndexMetadata();
            indexMetadata.setName(this.getIndexName(clazz, tableIndex));
            indexMetadata.setType(tableIndex.type());
            indexMetadata.setComment(tableIndex.comment());
            indexMetadata.setColumns(columnParams);
            return indexMetadata;
        }
        return null;
    }

    protected IndexMetadata newIndexMetadata() {
        return new IndexMetadata();
    }

    protected List<IndexMetadata.IndexColumnParam> getColumnParams(Class<?> clazz, TableIndex tableIndex) {
        String[] fields;
        ArrayList<IndexMetadata.IndexColumnParam> columnParams = new ArrayList<IndexMetadata.IndexColumnParam>();
        HashSet exitsColumns = new HashSet();
        IndexField[] sortFields = tableIndex.indexFields();
        if (sortFields.length > 0) {
            columnParams.addAll(Arrays.stream(sortFields).map(sortField -> {
                String realColumnName = TableBeanUtils.getRealColumnName(clazz, sortField.field());
                if (exitsColumns.contains(realColumnName)) {
                    return null;
                }
                exitsColumns.add(realColumnName);
                return IndexMetadata.IndexColumnParam.newInstance(realColumnName, sortField.sort());
            }).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        if ((fields = tableIndex.fields()).length > 0) {
            columnParams.addAll(Arrays.stream(fields).map(field -> {
                String realColumnName = TableBeanUtils.getRealColumnName(clazz, field);
                if (exitsColumns.contains(realColumnName)) {
                    return null;
                }
                exitsColumns.add(realColumnName);
                return IndexMetadata.IndexColumnParam.newInstance(realColumnName, null);
            }).filter(Objects::nonNull).collect(Collectors.toList()));
        }
        return columnParams;
    }
}

