/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.converter;

import java.util.List;

public class DatabaseTypeAndLength {
    private String type;
    private Integer length;
    private Integer decimalLength;
    private List<String> values;

    public DatabaseTypeAndLength(String type, Integer length, Integer decimalLength, List<String> values) {
        this.type = type;
        if (length != null && length >= 0) {
            this.length = length;
        }
        if (decimalLength != null && decimalLength >= 0) {
            this.decimalLength = decimalLength;
        }
        this.values = values;
    }

    public String getDefaultFullType() {
        String fullType = this.type;
        if (this.length != null) {
            fullType = fullType + "(" + this.length;
            if (this.decimalLength != null) {
                fullType = fullType + "," + this.decimalLength;
            }
            fullType = fullType + ")";
        }
        return fullType;
    }

    public String getType() {
        return this.type;
    }

    public Integer getLength() {
        return this.length;
    }

    public Integer getDecimalLength() {
        return this.decimalLength;
    }

    public List<String> getValues() {
        return this.values;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setLength(Integer length) {
        this.length = length;
    }

    public void setDecimalLength(Integer decimalLength) {
        this.decimalLength = decimalLength;
    }

    public void setValues(List<String> values) {
        this.values = values;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DatabaseTypeAndLength)) {
            return false;
        }
        DatabaseTypeAndLength other = (DatabaseTypeAndLength)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$length = this.getLength();
        Integer other$length = other.getLength();
        if (this$length == null ? other$length != null : !((Object)this$length).equals(other$length)) {
            return false;
        }
        Integer this$decimalLength = this.getDecimalLength();
        Integer other$decimalLength = other.getDecimalLength();
        if (this$decimalLength == null ? other$decimalLength != null : !((Object)this$decimalLength).equals(other$decimalLength)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        List<String> this$values = this.getValues();
        List<String> other$values = other.getValues();
        return !(this$values == null ? other$values != null : !((Object)this$values).equals(other$values));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DatabaseTypeAndLength;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $length = this.getLength();
        result = result * 59 + ($length == null ? 43 : ((Object)$length).hashCode());
        Integer $decimalLength = this.getDecimalLength();
        result = result * 59 + ($decimalLength == null ? 43 : ((Object)$decimalLength).hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        List<String> $values = this.getValues();
        result = result * 59 + ($values == null ? 43 : ((Object)$values).hashCode());
        return result;
    }

    public String toString() {
        return "DatabaseTypeAndLength(type=" + this.getType() + ", length=" + this.getLength() + ", decimalLength=" + this.getDecimalLength() + ", values=" + this.getValues() + ")";
    }
}

