/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy.mysql.builder;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.dromara.autotable.annotation.enums.IndexTypeEnum;
import org.dromara.autotable.core.strategy.IndexMetadata;
import org.dromara.autotable.core.strategy.mysql.builder.ColumnSqlBuilder;
import org.dromara.autotable.core.strategy.mysql.data.MysqlColumnMetadata;
import org.dromara.autotable.core.strategy.mysql.data.MysqlTableMetadata;
import org.dromara.autotable.core.utils.StringConnectHelper;
import org.dromara.autotable.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTableSqlBuilder {
    private static final Logger log = LoggerFactory.getLogger(CreateTableSqlBuilder.class);

    public static String buildSql(MysqlTableMetadata mysqlTableMetadata) {
        String name = mysqlTableMetadata.getTableName();
        List<MysqlColumnMetadata> mysqlColumnMetadataList = mysqlTableMetadata.getColumnMetadataList();
        List<IndexMetadata> indexMetadataList = mysqlTableMetadata.getIndexMetadataList();
        String collate = mysqlTableMetadata.getCollate();
        String engine = mysqlTableMetadata.getEngine();
        String characterSet = mysqlTableMetadata.getCharacterSet();
        String comment = mysqlTableMetadata.getComment();
        ArrayList<String> addItems = new ArrayList<String>();
        ArrayList<String> primaries = new ArrayList<String>();
        mysqlColumnMetadataList.forEach(columnData -> {
            if (columnData.isPrimary()) {
                columnData.setNotNull(true);
                primaries.add(columnData.getName());
            }
        });
        addItems.add(mysqlColumnMetadataList.stream().sorted(Comparator.comparingInt(MysqlColumnMetadata::getPosition)).map(ColumnSqlBuilder::buildSql).collect(Collectors.joining(",")));
        if (!primaries.isEmpty()) {
            String primaryKeySql = CreateTableSqlBuilder.getPrimaryKeySql(primaries);
            addItems.add(primaryKeySql);
        }
        addItems.add(indexMetadataList.stream().map(CreateTableSqlBuilder::getIndexSql).sorted().collect(Collectors.joining(",")));
        List<String> tableProperties = CreateTableSqlBuilder.getTableProperties(engine, characterSet, collate, comment);
        String addSql = addItems.stream().filter(StringUtils::hasText).collect(Collectors.joining(","));
        String propertiesSql = tableProperties.stream().filter(StringUtils::hasText).collect(Collectors.joining(","));
        return "CREATE TABLE `{tableName}` ({addItems}) {tableProperties};".replace("{tableName}", name).replace("{addItems}", addSql).replace("{tableProperties}", propertiesSql);
    }

    public static List<String> getTableProperties(String engine, String characterSet, String collate, String comment) {
        ArrayList<String> tableProperties = new ArrayList<String>();
        if (StringUtils.hasText(engine)) {
            tableProperties.add("ENGINE = " + engine);
        }
        if (StringUtils.hasText(characterSet)) {
            tableProperties.add("CHARACTER SET = " + characterSet);
        }
        if (StringUtils.hasText(collate)) {
            tableProperties.add("COLLATE = " + collate);
        }
        if (StringUtils.hasText(comment)) {
            tableProperties.add("COMMENT = '{comment}'".replace("{comment}", comment));
        }
        return tableProperties;
    }

    public static String getIndexSql(IndexMetadata indexMetadata) {
        return StringConnectHelper.newInstance("{indexType} INDEX `{indexName}`({columns}) {method} {indexComment}").replace("{indexType}", indexMetadata.getType() == IndexTypeEnum.UNIQUE ? "UNIQUE" : "").replace("{indexName}", indexMetadata.getName()).replace("{columns}", () -> {
            List<IndexMetadata.IndexColumnParam> columnParams = indexMetadata.getColumns();
            return columnParams.stream().map(column -> "`{column}` {sortMode}".replace("{column}", column.getColumn()).replace("{sortMode}", column.getSort() != null ? column.getSort().name() : "")).collect(Collectors.joining(","));
        }).replace("{method}", StringUtils.hasText(indexMetadata.getMethod()) ? "USING " + indexMetadata.getMethod() : "").replace("{indexComment}", StringUtils.hasText(indexMetadata.getComment()) ? "COMMENT '" + indexMetadata.getComment() + "'" : "").toString();
    }

    public static String getPrimaryKeySql(List<String> primaries) {
        return "PRIMARY KEY ({primaries})".replace("{primaries}", primaries.stream().map(fieldName -> "`" + fieldName + "`").collect(Collectors.joining(",")));
    }
}

