/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.recordsql;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.Utils;
import org.dromara.autotable.core.config.PropertyConfig;
import org.dromara.autotable.core.dynamicds.DatasourceNameManager;
import org.dromara.autotable.core.dynamicds.IDataSourceHandler;
import org.dromara.autotable.core.dynamicds.SqlSessionFactoryManager;
import org.dromara.autotable.core.recordsql.AutoTableExecuteSqlLog;
import org.dromara.autotable.core.recordsql.RecordSqlHandler;
import org.dromara.autotable.core.strategy.IStrategy;
import org.dromara.autotable.core.utils.StringUtils;
import org.dromara.autotable.core.utils.TableBeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordSqlDbHandler
implements RecordSqlHandler {
    private static final Logger log = LoggerFactory.getLogger(RecordSqlDbHandler.class);

    @Override
    public void record(List<AutoTableExecuteSqlLog> autoTableExecuteSqlLogs) {
        PropertyConfig.RecordSqlProperties recordSqlConfig = AutoTableGlobalConfig.getAutoTableProperties().getRecordSql();
        String tableName = recordSqlConfig.getTableName();
        if (StringUtils.noText(tableName)) {
            tableName = TableBeanUtils.getTableName(AutoTableExecuteSqlLog.class);
        }
        SqlSessionFactory sqlSessionFactory = SqlSessionFactoryManager.getSqlSessionFactory();
        try (SqlSession sqlSession = sqlSessionFactory.openSession();
             Connection connection = sqlSession.getConnection();){
            log.debug("\u5f00\u542fsql\u8bb0\u5f55\u4e8b\u52a1");
            connection.setAutoCommit(false);
            try {
                for (AutoTableExecuteSqlLog autoTableExecuteSqlLog : autoTableExecuteSqlLogs) {
                    boolean exists;
                    String schema = connection.getSchema();
                    if (StringUtils.hasText(autoTableExecuteSqlLog.getTableSchema())) {
                        schema = autoTableExecuteSqlLog.getTableSchema();
                    }
                    if (!(exists = Utils.tableIsExists(connection, schema, tableName, new String[]{"TABLE"}, true))) {
                        RecordSqlDbHandler.initTable(connection);
                        log.info("\u521d\u59cb\u5316sql\u8bb0\u5f55\u8868\uff1a{}", (Object)tableName);
                    }
                    RecordSqlDbHandler.insertLog(tableName, autoTableExecuteSqlLog, connection);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("\u8bb0\u5f55sql\u5230\u6570\u636e\u5e93\u51fa\u9519", e);
            }
            log.debug("\u63d0\u4ea4sql\u8bb0\u5f55\u4e8b\u52a1");
            connection.commit();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            log.debug("\u5173\u95edsql\u8bb0\u5f55\u4e8b\u52a1");
        }
    }

    private static void insertLog(String tableName, AutoTableExecuteSqlLog autoTableExecuteSqlLog, Connection connection) throws SQLException {
        Class<AutoTableExecuteSqlLog> sqlLogClass = AutoTableExecuteSqlLog.class;
        List columnFields = Arrays.stream(sqlLogClass.getDeclaredFields()).filter(field -> TableBeanUtils.isIncludeField(field, sqlLogClass)).collect(Collectors.toList());
        List columns = columnFields.stream().map(field -> TableBeanUtils.getRealColumnName(sqlLogClass, field)).collect(Collectors.toList());
        List values = columnFields.stream().map(field -> {
            try {
                field.setAccessible(true);
                return field.get(autoTableExecuteSqlLog);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }).collect(Collectors.toList());
        String insertSql = String.format("INSERT INTO %s (%s) VALUES (%s)", tableName, String.join((CharSequence)", ", columns), IntStream.range(0, values.size()).mapToObj(i -> "?").collect(Collectors.joining(", ")));
        log.info("\u63d2\u5165SQL\u8bb0\u5f55\uff1a{}", (Object)insertSql);
        PreparedStatement preparedStatement = connection.prepareStatement(insertSql);
        for (int i2 = 0; i2 < values.size(); ++i2) {
            preparedStatement.setObject(i2 + 1, values.get(i2));
        }
        preparedStatement.executeUpdate();
    }

    private static void initTable(Connection connection) throws SQLException {
        IDataSourceHandler datasourceHandler = AutoTableGlobalConfig.getDatasourceHandler();
        String datasourceName = DatasourceNameManager.getDatasourceName();
        String databaseDialect = datasourceHandler.getDatabaseDialect(datasourceName);
        IStrategy<?, ?, ?> createTableStrategy = AutoTableGlobalConfig.getStrategy(databaseDialect);
        List<String> initTableSql = createTableStrategy.createTable(AutoTableExecuteSqlLog.class);
        try (Statement statement = connection.createStatement();){
            for (String sql : initTableSql) {
                statement.execute(sql);
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("\u521d\u59cb\u5316sql\u8bb0\u5f55\u8868\u5931\u8d25", e);
        }
    }
}

