/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy.h2;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.dromara.autotable.annotation.enums.DefaultValueEnum;
import org.dromara.autotable.annotation.enums.IndexTypeEnum;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.converter.DatabaseTypeAndLength;
import org.dromara.autotable.core.converter.DefaultTypeEnumInterface;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.strategy.DefaultTableMetadata;
import org.dromara.autotable.core.strategy.IStrategy;
import org.dromara.autotable.core.strategy.IndexMetadata;
import org.dromara.autotable.core.strategy.h2.builder.CreateTableSqlBuilder;
import org.dromara.autotable.core.strategy.h2.builder.H2TableMetadataBuilder;
import org.dromara.autotable.core.strategy.h2.builder.ModifyTableSqlBuilder;
import org.dromara.autotable.core.strategy.h2.data.H2CompareTableInfo;
import org.dromara.autotable.core.strategy.h2.data.H2DefaultTypeEnum;
import org.dromara.autotable.core.strategy.h2.data.H2TypeHelper;
import org.dromara.autotable.core.strategy.h2.data.dbdata.InformationSchemaColumns;
import org.dromara.autotable.core.strategy.h2.data.dbdata.InformationSchemaIndexes;
import org.dromara.autotable.core.strategy.h2.data.dbdata.InformationSchemaTables;
import org.dromara.autotable.core.strategy.h2.mapper.H2TablesMapper;
import org.dromara.autotable.core.utils.StringUtils;

public class H2Strategy
implements IStrategy<DefaultTableMetadata, H2CompareTableInfo, H2TablesMapper> {
    @Override
    public String databaseDialect() {
        return "H2";
    }

    @Override
    public Map<Class<?>, DefaultTypeEnumInterface> typeMapping() {
        return new HashMap<Class<?>, DefaultTypeEnumInterface>(32){
            {
                this.put(String.class, H2DefaultTypeEnum.CHARACTER_VARYING);
                this.put(Character.class, H2DefaultTypeEnum.CHARACTER);
                this.put(Character.TYPE, H2DefaultTypeEnum.CHARACTER);
                this.put(Byte.TYPE, H2DefaultTypeEnum.TINYINT);
                this.put(Byte.class, H2DefaultTypeEnum.TINYINT);
                this.put(Short.TYPE, H2DefaultTypeEnum.SMALLINT);
                this.put(Short.class, H2DefaultTypeEnum.SMALLINT);
                this.put(Integer.TYPE, H2DefaultTypeEnum.INTEGER);
                this.put(Integer.class, H2DefaultTypeEnum.INTEGER);
                this.put(Long.TYPE, H2DefaultTypeEnum.BIGINT);
                this.put(Long.class, H2DefaultTypeEnum.BIGINT);
                this.put(Float.TYPE, H2DefaultTypeEnum.REAL);
                this.put(Float.class, H2DefaultTypeEnum.REAL);
                this.put(Double.TYPE, H2DefaultTypeEnum.NUMERIC);
                this.put(Double.class, H2DefaultTypeEnum.NUMERIC);
                this.put(BigDecimal.class, H2DefaultTypeEnum.NUMERIC);
                this.put(Boolean.class, H2DefaultTypeEnum.BOOLEAN);
                this.put(Time.class, H2DefaultTypeEnum.TIME);
                this.put(LocalTime.class, H2DefaultTypeEnum.TIME);
                this.put(Date.class, H2DefaultTypeEnum.DATE);
                this.put(LocalDate.class, H2DefaultTypeEnum.DATE);
                this.put(java.util.Date.class, H2DefaultTypeEnum.TIMESTAMP);
                this.put(LocalDateTime.class, H2DefaultTypeEnum.TIMESTAMP);
            }
        };
    }

    @Override
    public String dropTable(String schema, String tableName) {
        return String.format("DROP TABLE IF EXISTS %s CASCADE", H2Strategy.withSchemaName(schema, tableName));
    }

    @Override
    @NonNull
    public DefaultTableMetadata analyseClass(Class<?> beanClass) {
        return new H2TableMetadataBuilder().build(beanClass);
    }

    @Override
    public List<String> createTable(DefaultTableMetadata tableMetadata) {
        return CreateTableSqlBuilder.buildColumnSql(tableMetadata);
    }

    @Override
    @NonNull
    public H2CompareTableInfo compareTable(DefaultTableMetadata tableMetadata) {
        String tableName = tableMetadata.getTableName();
        String schema = tableMetadata.getSchema();
        H2CompareTableInfo h2CompareTableInfo = new H2CompareTableInfo(tableName, schema);
        this.compareTableInfo(tableMetadata, h2CompareTableInfo);
        this.compareColumnInfo(tableMetadata, h2CompareTableInfo);
        this.compareIndexInfo(tableMetadata, h2CompareTableInfo);
        return h2CompareTableInfo;
    }

    private void compareIndexInfo(DefaultTableMetadata tableMetadata, H2CompareTableInfo h2CompareTableInfo) {
        String tableName = tableMetadata.getTableName();
        String schema = tableMetadata.getSchema();
        List informationSchemaIndexes = this.executeReturn(pgsqlTablesMapper -> pgsqlTablesMapper.findIndexInformation(schema, tableName));
        Map<String, List<InformationSchemaIndexes>> dbIndexMap = informationSchemaIndexes.stream().collect(Collectors.groupingBy(InformationSchemaIndexes::getIndexName));
        List<IndexMetadata> indexMetadataList = tableMetadata.getIndexMetadataList();
        for (IndexMetadata indexMetadata : indexMetadataList) {
            String dbIndexColumnStr;
            boolean dbIsUniqueIndex;
            boolean isNewIndex;
            String indexName = indexMetadata.getName().toUpperCase();
            String indexComment = indexMetadata.getComment();
            List<InformationSchemaIndexes> dbIndex = dbIndexMap.remove(indexName);
            boolean bl = isNewIndex = dbIndex == null;
            if (isNewIndex) {
                h2CompareTableInfo.addNewIndex(indexMetadata);
                if (!StringUtils.hasText(indexComment)) continue;
                h2CompareTableInfo.addIndexComment(indexName, indexComment);
                continue;
            }
            InformationSchemaIndexes firstIndexColumns = dbIndex.get(0);
            boolean isUniqueIndex = indexMetadata.getType() == IndexTypeEnum.UNIQUE;
            if (isUniqueIndex != (dbIsUniqueIndex = firstIndexColumns.getIsUnique().booleanValue())) {
                h2CompareTableInfo.addModifyIndex(indexMetadata);
                continue;
            }
            if (indexMetadata.getColumns().size() != dbIndex.size()) {
                h2CompareTableInfo.addModifyIndex(indexMetadata);
                continue;
            }
            String indexColumnStr = indexMetadata.getColumns().stream().map(index -> {
                String column = index.getColumn();
                column = index.getSort() != null ? column + " " + index.getSort().name() : column + " ASC";
                return column.toUpperCase();
            }).collect(Collectors.joining(","));
            if (!indexColumnStr.equals(dbIndexColumnStr = dbIndex.stream().map(index -> index.getColumnName() + " " + index.getOrderingSpecification()).collect(Collectors.joining(",")))) {
                h2CompareTableInfo.addModifyIndex(indexMetadata);
                continue;
            }
            String dbIndexComment = firstIndexColumns.getRemarks();
            if (!StringUtils.hasText(indexComment) && !StringUtils.hasText(dbIndexComment) || Objects.equals(dbIndexComment, indexComment)) continue;
            h2CompareTableInfo.addIndexComment(indexName, indexComment);
        }
        Set<String> needRemoveIndexes = dbIndexMap.keySet();
        if (!needRemoveIndexes.isEmpty() && AutoTableGlobalConfig.getAutoTableProperties().getAutoDropIndex().booleanValue()) {
            h2CompareTableInfo.addDropIndexes(needRemoveIndexes);
        }
    }

    private void compareColumnInfo(DefaultTableMetadata tableMetadata, H2CompareTableInfo h2CompareTableInfo) {
        String tableName = tableMetadata.getTableName();
        String schema = tableMetadata.getSchema();
        List informationSchemaColumns = this.executeReturn(mapper -> mapper.findColumnInformation(schema, tableName));
        Map pgsqlFieldDetailMap = informationSchemaColumns.stream().collect(Collectors.toMap(InformationSchemaColumns::getColumnName, Function.identity()));
        List<ColumnMetadata> columnMetadataList = tableMetadata.getColumnMetadataList();
        for (ColumnMetadata columnMetadata : columnMetadataList) {
            boolean isPrimaryDiff;
            boolean isAutoIncrement;
            String columnName = columnMetadata.getName().toUpperCase();
            InformationSchemaColumns schemaColumns = (InformationSchemaColumns)pgsqlFieldDetailMap.remove(columnName);
            String columnComment = columnMetadata.getComment();
            if (schemaColumns == null) {
                h2CompareTableInfo.addColumnComment(columnName, columnComment);
                h2CompareTableInfo.addNewColumn(columnMetadata);
                continue;
            }
            String dbColumnComment = schemaColumns.getRemarks();
            if ((StringUtils.hasText(columnComment) || StringUtils.hasText(dbColumnComment)) && !Objects.equals(dbColumnComment, columnComment)) {
                h2CompareTableInfo.addColumnComment(columnName, columnComment);
            }
            boolean isTypeDiff = this.isTypeDiff(columnMetadata, schemaColumns);
            boolean isNotnullDiff = columnMetadata.isNotNull() != Objects.equals(schemaColumns.getIsNullable(), "NO");
            boolean isDefaultDiff = this.isDefaultDiff(columnMetadata, schemaColumns);
            boolean bl = isAutoIncrement = columnMetadata.isAutoIncrement() != schemaColumns.autoIncrement();
            if (isTypeDiff || isNotnullDiff || isDefaultDiff || isAutoIncrement) {
                h2CompareTableInfo.addModifyColumn(columnMetadata);
                h2CompareTableInfo.addColumnComment(columnName, columnComment);
            }
            if (!(isPrimaryDiff = columnMetadata.isPrimary() != schemaColumns.primaryKey())) continue;
            h2CompareTableInfo.addNewPrimary(columnMetadata);
        }
        Set<String> needRemoveColumns = pgsqlFieldDetailMap.keySet();
        if (!needRemoveColumns.isEmpty() && AutoTableGlobalConfig.getAutoTableProperties().getAutoDropColumn().booleanValue()) {
            h2CompareTableInfo.addDropColumns(needRemoveColumns);
        }
    }

    private boolean isTypeDiff(ColumnMetadata columnMetadata, InformationSchemaColumns informationSchemaColumns) {
        String fieldType;
        boolean fieldIsNumber;
        boolean columnIsNumber;
        boolean fieldIsCharString;
        String dbColumnType = informationSchemaColumns.getDataType();
        DatabaseTypeAndLength columnMetadataType = columnMetadata.getType();
        boolean columnIsCharString = "CHARACTER VARYING".equals(dbColumnType);
        if (columnIsCharString != (fieldIsCharString = H2TypeHelper.isCharString(columnMetadataType))) {
            return true;
        }
        if (columnIsCharString && fieldIsCharString) {
            Long characterMaximumLength = informationSchemaColumns.getCharacterMaximumLength();
            if (columnMetadataType.getLength() != null && !Objects.equals(characterMaximumLength, columnMetadataType.getLength())) {
                return true;
            }
        }
        if ((columnIsNumber = H2TypeHelper.isNumber(dbColumnType)) != (fieldIsNumber = H2TypeHelper.isNumber(columnMetadataType))) {
            return true;
        }
        if (columnIsNumber && fieldIsNumber) {
            Integer numericPrecision = informationSchemaColumns.getNumericPrecision();
            Integer numericScale = informationSchemaColumns.getNumericScale();
            if (columnMetadataType.getLength() != null && !Objects.equals(numericPrecision, columnMetadataType.getLength()) || columnMetadataType.getDecimalLength() != null && !Objects.equals(numericScale, columnMetadataType.getDecimalLength())) {
                return true;
            }
        }
        return !Objects.equals(dbColumnType, fieldType = columnMetadataType.getType().toUpperCase());
    }

    private boolean isDefaultDiff(ColumnMetadata columnMetadata, InformationSchemaColumns schemaColumns) {
        String dbDefaultValue = schemaColumns.getColumnDefault();
        DefaultValueEnum defaultValueType = columnMetadata.getDefaultValueType();
        if (DefaultValueEnum.isValid((DefaultValueEnum)defaultValueType)) {
            if (defaultValueType == DefaultValueEnum.EMPTY_STRING) {
                return !"''".equals(dbDefaultValue);
            }
            if (defaultValueType == DefaultValueEnum.NULL) {
                return dbDefaultValue != null && !"NULL".equalsIgnoreCase(dbDefaultValue);
            }
        } else {
            String defaultValue = columnMetadata.getDefaultValue();
            if (defaultValue != null && !defaultValue.startsWith("'") && !defaultValue.endsWith("'") && H2TypeHelper.isCharString(columnMetadata.getType())) {
                defaultValue = "'" + defaultValue + "'";
            }
            return !Objects.equals(defaultValue = H2Strategy.encodeChinese(defaultValue), dbDefaultValue);
        }
        return false;
    }

    public static String encodeChinese(String input) {
        if (StringUtils.noText(input)) {
            return input;
        }
        StringBuilder unicodeString = new StringBuilder();
        boolean hasChinese = false;
        for (char c : input.toCharArray()) {
            if (c >= '\u4e00' && c <= '\u9fa5') {
                hasChinese = true;
                unicodeString.append(String.format("\\%04x", c));
                continue;
            }
            unicodeString.append(c);
        }
        if (hasChinese) {
            if (!input.startsWith("'")) {
                unicodeString.insert(0, "'");
            }
            if (!input.endsWith("'")) {
                unicodeString.append("'");
            }
            return "U&" + unicodeString;
        }
        return input;
    }

    private void compareTableInfo(DefaultTableMetadata tableMetadata, H2CompareTableInfo h2CompareTableInfo) {
        String tableName = tableMetadata.getTableName();
        String schema = tableMetadata.getSchema();
        InformationSchemaTables informationSchemaTables = this.executeReturn(mapper -> mapper.findTableInformation(schema, tableName));
        String dbTableComment = informationSchemaTables.getRemarks();
        String tableComment = tableMetadata.getComment();
        if ((StringUtils.hasText(tableComment) || StringUtils.hasText(dbTableComment)) && !Objects.equals(dbTableComment, tableComment)) {
            h2CompareTableInfo.setComment(tableComment);
        }
    }

    @Override
    public List<String> modifyTable(H2CompareTableInfo compareTableInfo) {
        return ModifyTableSqlBuilder.buildSql(compareTableInfo);
    }

    public static String withSchemaName(String schema, String ... names) {
        String name = String.join((CharSequence)".", names);
        if (StringUtils.hasText(schema)) {
            return schema + "." + name;
        }
        return name;
    }
}

