/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.dynamicds;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.ibatis.session.Configuration;
import org.dromara.autotable.core.dynamicds.DatasourceNameManager;
import org.dromara.autotable.core.dynamicds.SqlSessionFactoryManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface IDataSourceHandler {
    public static final Logger log = LoggerFactory.getLogger(IDataSourceHandler.class);

    default public void handleAnalysis(Set<Class<?>> classList, BiConsumer<String, Set<Class<?>>> consumer) {
        Map needHandleTableMap = classList.stream().collect(Collectors.groupingBy(this::getDataSourceName, Collectors.toSet()));
        needHandleTableMap.forEach((dataSource, entityClasses) -> {
            log.info("\u4f7f\u7528\u6570\u636e\u6e90\uff1a{}", dataSource);
            this.useDataSource((String)dataSource);
            DatasourceNameManager.setDatasourceName(dataSource);
            try {
                String databaseDialect = this.getDatabaseDialect((String)dataSource);
                log.info("\u6570\u636e\u5e93\u65b9\u8a00\uff08{}\uff09", (Object)databaseDialect);
                consumer.accept(databaseDialect, (Set<Class<?>>)entityClasses);
            }
            finally {
                log.info("\u6e05\u7406\u6570\u636e\u6e90\uff1a{}", dataSource);
                this.clearDataSource((String)dataSource);
                DatasourceNameManager.cleanDatasourceName();
            }
        });
    }

    default public String getDatabaseDialect(String dataSource) {
        String string;
        block8: {
            Configuration configuration = SqlSessionFactoryManager.getSqlSessionFactory().getConfiguration();
            Connection connection = configuration.getEnvironment().getDataSource().getConnection();
            try {
                DatabaseMetaData metaData = connection.getMetaData();
                log.info("\u6570\u636e\u5e93\u94fe\u63a5 => {}", (Object)metaData.getURL());
                string = metaData.getDatabaseProductName();
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new RuntimeException("\u83b7\u53d6\u6570\u636e\u65b9\u8a00\u5931\u8d25", e);
                }
            }
            connection.close();
        }
        return string;
    }

    public void useDataSource(String var1);

    public void clearDataSource(String var1);

    @NonNull
    public String getDataSourceName(Class<?> var1);
}

