/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.recordsql;

import java.util.List;
import org.dromara.autotable.core.AutoTableGlobalConfig;
import org.dromara.autotable.core.config.PropertyConfig;
import org.dromara.autotable.core.recordsql.AutoTableExecuteSqlLog;
import org.dromara.autotable.core.recordsql.RecordSqlDbHandler;
import org.dromara.autotable.core.recordsql.RecordSqlFileHandler;
import org.dromara.autotable.core.recordsql.RecordSqlHandler;
import org.dromara.autotable.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordSqlService {
    private static final Logger log = LoggerFactory.getLogger(RecordSqlService.class);

    public static void record(List<AutoTableExecuteSqlLog> autoTableExecuteSqlLogs) {
        RecordSqlHandler recordSqlHandler;
        PropertyConfig.RecordSqlProperties recordSql = AutoTableGlobalConfig.getAutoTableProperties().getRecordSql();
        PropertyConfig.RecordSqlProperties.TypeEnum recordType = recordSql.getRecordType();
        switch (recordType) {
            case db: {
                recordSqlHandler = new RecordSqlDbHandler();
                break;
            }
            case file: {
                recordSqlHandler = new RecordSqlFileHandler();
                break;
            }
            default: {
                recordSqlHandler = AutoTableGlobalConfig.getCustomRecordSqlHandler();
            }
        }
        String version = recordSql.getVersion();
        if (StringUtils.noText(version)) {
            log.warn("AutoTable\u7684SQL\u8bb0\u5f55\u529f\u80fd\u6ca1\u6709\u914d\u7f6e\u7248\u672c\u53f7\uff0c\u9ed8\u8ba4\u4e3a\u7a7a\uff0c\u5f3a\u70c8\u5efa\u8bae\u5173\u8054\u5373\u5c06\u4e0a\u7ebf\u7684\u7248\u672c\u53f7\uff0c\u6839\u636e\u7248\u672c\u7ba1\u7406SQL\u65e5\u5fd7\uff0c\u907f\u514d\u6df7\u4e71");
        }
        for (AutoTableExecuteSqlLog autoTableExecuteSqlLog : autoTableExecuteSqlLogs) {
            autoTableExecuteSqlLog.setVersion(version);
            recordSqlHandler.record(autoTableExecuteSqlLog);
        }
    }
}

