/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy.h2.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dromara.autotable.annotation.enums.DefaultValueEnum;
import org.dromara.autotable.annotation.enums.IndexTypeEnum;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.strategy.DefaultTableMetadata;
import org.dromara.autotable.core.strategy.IndexMetadata;
import org.dromara.autotable.core.strategy.h2.H2Strategy;
import org.dromara.autotable.core.utils.StringConnectHelper;
import org.dromara.autotable.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTableSqlBuilder {
    private static final Logger log = LoggerFactory.getLogger(CreateTableSqlBuilder.class);

    public static List<String> buildColumnSql(DefaultTableMetadata tableMetadata) {
        String schema = tableMetadata.getSchema();
        String tableName = tableMetadata.getTableName();
        String createTableSql = CreateTableSqlBuilder.getCreateTableSql(tableMetadata);
        List<IndexMetadata> indexMetadataList = tableMetadata.getIndexMetadataList();
        List<String> createIndexSql = CreateTableSqlBuilder.getCreateIndexSql(schema, tableName, indexMetadataList);
        List<String> addCommentSql = CreateTableSqlBuilder.getAllCommentSql(tableMetadata);
        ArrayList<String> sqlList = new ArrayList<String>();
        sqlList.add(createTableSql);
        sqlList.addAll(createIndexSql);
        sqlList.addAll(addCommentSql);
        return sqlList;
    }

    public static List<String> getCreateIndexSql(String schema, String tableName, List<IndexMetadata> indexMetadataList) {
        return indexMetadataList.stream().map(indexMetadata -> StringConnectHelper.newInstance("CREATE {indexType} INDEX {indexName} ON {tableName} {method} ({columns});").replace("{indexType}", indexMetadata.getType() == IndexTypeEnum.UNIQUE ? "UNIQUE" : "").replace("{indexName}", "\"" + indexMetadata.getName() + "\"").replace("{tableName}", H2Strategy.withSchemaName(schema, tableName)).replace("{method}", StringUtils.hasText(indexMetadata.getMethod()) ? "USING " + indexMetadata.getMethod() : "").replace("{columns}", () -> {
            List<IndexMetadata.IndexColumnParam> columnParams = indexMetadata.getColumns();
            return columnParams.stream().map(column -> "{column} {sortMode}".replace("{column}", "\"" + column.getColumn() + "\"").replace("{sortMode}", column.getSort() != null ? column.getSort().name() : "")).collect(Collectors.joining(","));
        }).toString()).collect(Collectors.toList());
    }

    private static List<String> getAllCommentSql(DefaultTableMetadata tableMetadata) {
        String schema = tableMetadata.getSchema();
        String tableName = tableMetadata.getTableName();
        String comment = tableMetadata.getComment();
        List<ColumnMetadata> columnMetadataList = tableMetadata.getColumnMetadataList();
        List<IndexMetadata> indexMetadataList = tableMetadata.getIndexMetadataList();
        return CreateTableSqlBuilder.getAllCommentSql(schema, tableName, comment, columnMetadataList.stream().collect(Collectors.toMap(ColumnMetadata::getName, ColumnMetadata::getComment)), indexMetadataList.stream().collect(Collectors.toMap(IndexMetadata::getName, IndexMetadata::getComment)));
    }

    public static List<String> getAllCommentSql(String schema, String tableName, String tableComment, Map<String, String> columnCommentMap, Map<String, String> indexCommentMap) {
        ArrayList<String> commentSqlList = new ArrayList<String>();
        if (tableComment != null) {
            String addTableComment = StringConnectHelper.newInstance("COMMENT ON TABLE {tableName} IS {comment};").replace("{tableName}", H2Strategy.withSchemaName(schema, tableName)).replace("{comment}", tableComment.isEmpty() ? "null" : "'" + tableComment + "'").toString();
            commentSqlList.add(addTableComment);
        }
        columnCommentMap.entrySet().stream().map(columnComment -> StringConnectHelper.newInstance("COMMENT ON COLUMN {name} IS {comment};").replace("{name}", H2Strategy.withSchemaName(schema, tableName, (String)columnComment.getKey())).replace("{comment}", () -> {
            String value = (String)columnComment.getValue();
            return value == null || value.isEmpty() ? "null" : "'" + value + "'";
        }).toString()).forEach(commentSqlList::add);
        indexCommentMap.entrySet().stream().map(indexComment -> StringConnectHelper.newInstance("COMMENT ON INDEX {name} IS {comment};").replace("{name}", H2Strategy.withSchemaName(schema, (String)indexComment.getKey())).replace("{comment}", () -> {
            String value = (String)indexComment.getValue();
            return value == null || value.isEmpty() ? "null" : "'" + value + "'";
        }).toString()).forEach(commentSqlList::add);
        return commentSqlList;
    }

    private static String getCreateTableSql(DefaultTableMetadata tableMetadata) {
        String schema = tableMetadata.getSchema();
        String name = tableMetadata.getTableName();
        List<ColumnMetadata> columnMetadataList = tableMetadata.getColumnMetadataList();
        ArrayList<String> columnList = new ArrayList<String>();
        ArrayList<String> primaries = new ArrayList<String>();
        columnMetadataList.forEach(columnData -> {
            if (columnData.isPrimary()) {
                columnData.setNotNull(true);
                primaries.add("\"" + columnData.getName() + "\"");
            }
        });
        columnList.add(columnMetadataList.stream().map(CreateTableSqlBuilder::buildColumnSql).collect(Collectors.joining(",")));
        if (!primaries.isEmpty()) {
            String primaryKeySql = CreateTableSqlBuilder.getPrimaryKeySql(primaries);
            columnList.add(primaryKeySql);
        }
        String columnSql = columnList.stream().filter(StringUtils::hasText).collect(Collectors.joining(","));
        return "CREATE TABLE {tableName} ({columnList});".replace("{tableName}", H2Strategy.withSchemaName(schema, name)).replace("{columnList}", columnSql);
    }

    public static String buildColumnSql(ColumnMetadata columnMetadata) {
        return StringConnectHelper.newInstance("{columnName} {typeAndLength} {null} {default} {autoIncrement}").replace("{columnName}", "\"" + columnMetadata.getName() + "\"").replace("{typeAndLength}", columnMetadata.getType().getDefaultFullType()).replace("{autoIncrement}", columnMetadata.isAutoIncrement() ? "auto_increment" : "").replace("{null}", columnMetadata.isNotNull() ? "NOT NULL" : "").replace("{default}", () -> {
            DefaultValueEnum defaultValueType = columnMetadata.getDefaultValueType();
            if (defaultValueType == DefaultValueEnum.NULL) {
                return "DEFAULT NULL";
            }
            if (defaultValueType == DefaultValueEnum.EMPTY_STRING) {
                return "DEFAULT ''";
            }
            String defaultValue = columnMetadata.getDefaultValue();
            if (DefaultValueEnum.isCustom((DefaultValueEnum)defaultValueType) && StringUtils.hasText(defaultValue)) {
                defaultValue = H2Strategy.encodeChinese(defaultValue);
                return "DEFAULT " + defaultValue;
            }
            return "";
        }).toString();
    }

    private static String getPrimaryKeySql(List<String> primaries) {
        return "PRIMARY KEY ({primaries})".replace("{primaries}", String.join((CharSequence)",", primaries));
    }
}

