/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy.mysql;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.dromara.autotable.annotation.ColumnType;
import org.dromara.autotable.annotation.enums.DefaultValueEnum;
import org.dromara.autotable.core.converter.DatabaseTypeAndLength;
import org.dromara.autotable.core.strategy.mysql.data.MysqlColumnMetadata;
import org.dromara.autotable.core.strategy.mysql.data.MysqlTypeHelper;

public class ParamValidChecker {
    private static final IColumnChecker CHECK_AUTO_INCREMENT = (clazz, field, columnParam) -> {
        DatabaseTypeAndLength columnType = columnParam.getType();
        if (columnParam.isAutoIncrement() && !MysqlTypeHelper.isNumber(columnType)) {
            return new RuntimeException(String.format("\u7c7b(%s)\u7684\u5b57\u6bb5(%s[%s])\u8bbe\u7f6e\u4e86\u81ea\u589e\uff0c\u4f46\u662f\u5339\u914d\u5230\u7684(%s)\u975e\u6570\u5b57\u7c7b\u578b\uff0c\u65e0\u6cd5\u81ea\u589e\uff0c\u8bf7\u5c1d\u8bd5\u901a\u8fc7@%s\u624b\u52a8\u6307\u5b9a\u6570\u636e\u5e93\u7c7b\u578b\u6216\u66f4\u6362\u7c7b\u7684\u5b57\u6bb5\u7c7b\u578b", clazz.getName(), field.getName(), field.getType().getName(), columnType.getType(), ColumnType.class.getName()));
        }
        return null;
    };
    private static final IColumnChecker CHECK_DEFAULT_IS_EMPTY_STRING = (clazz, field, columnParam) -> {
        boolean defaultIsEmptyString;
        DatabaseTypeAndLength columnType = columnParam.getType();
        boolean bl = defaultIsEmptyString = columnParam.getDefaultValueType() == DefaultValueEnum.EMPTY_STRING;
        if (defaultIsEmptyString && !MysqlTypeHelper.isCharString(columnType)) {
            return new RuntimeException(String.format("\u7c7b(%s)\u7684\u5b57\u6bb5(%s[%s])\u8bbe\u7f6e\u4e86\u9ed8\u8ba4\u503c\u4e3a\u7a7a\u5b57\u7b26\uff0c\u4f46\u662f\u5339\u914d\u5230\u7684(%s)\u975e\u5b57\u7b26\u7c7b\u578b\uff0c\u8bf7\u5c1d\u8bd5\u901a\u8fc7@%s\u624b\u52a8\u6307\u5b9a\u6570\u636e\u5e93\u7c7b\u578b\u6216\u66f4\u6362\u7c7b\u7684\u5b57\u6bb5\u7c7b\u578b", clazz.getName(), field.getName(), field.getType().getName(), columnType.getType(), ColumnType.class.getName()));
        }
        return null;
    };
    private static final List<IColumnChecker> COLUMN_PARAM_CHECKER_LIST = Arrays.asList(CHECK_AUTO_INCREMENT, CHECK_DEFAULT_IS_EMPTY_STRING);

    public static void checkColumnParam(Class<?> clazz, Field field, MysqlColumnMetadata mysqlColumnMetadata) {
        for (IColumnChecker iColumnChecker : COLUMN_PARAM_CHECKER_LIST) {
            RuntimeException exception = iColumnChecker.check(clazz, field, mysqlColumnMetadata);
            if (exception == null) continue;
            throw exception;
        }
    }

    @FunctionalInterface
    public static interface IColumnChecker {
        public RuntimeException check(Class<?> var1, Field var2, MysqlColumnMetadata var3);
    }
}

