/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy.sqlite.builder;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.dromara.autotable.annotation.enums.IndexTypeEnum;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.strategy.IndexMetadata;
import org.dromara.autotable.core.strategy.sqlite.builder.ColumnSqlBuilder;
import org.dromara.autotable.core.utils.StringConnectHelper;
import org.dromara.autotable.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTableSqlBuilder {
    private static final Logger log = LoggerFactory.getLogger(CreateTableSqlBuilder.class);

    public static String buildTableSql(String name, String comment, List<ColumnMetadata> columnMetadataList) {
        ArrayList<String> primaries = new ArrayList<String>();
        columnMetadataList.forEach(columnData -> {
            if (columnData.isPrimary()) {
                columnData.setNotNull(true);
                primaries.add(columnData.getName());
            }
        });
        boolean isSinglePrimaryKey = primaries.size() == 1;
        boolean hasPrimaries = !primaries.isEmpty() && !isSinglePrimaryKey;
        ArrayList<String> addItems = new ArrayList<String>();
        AtomicInteger count = new AtomicInteger(0);
        addItems.add(columnMetadataList.stream().map(columnData -> {
            boolean isNotLastItem = count.incrementAndGet() < columnMetadataList.size();
            return ColumnSqlBuilder.buildSql(columnData, isSinglePrimaryKey, isNotLastItem || hasPrimaries);
        }).collect(Collectors.joining("\n")));
        if (hasPrimaries) {
            String primaryKeySql = CreateTableSqlBuilder.getPrimaryKeySql(primaries);
            addItems.add(primaryKeySql);
        }
        String addSql = addItems.stream().filter(StringUtils::hasText).collect(Collectors.joining(","));
        return "CREATE TABLE `{tableName}`{comment} \n(\n{addItems}\n);".replace("{tableName}", name).replace("{comment}", StringUtils.hasText(comment) ? " -- " + comment : "").replace("{addItems}", addSql);
    }

    public static List<String> buildIndexSql(String name, List<IndexMetadata> indexMetadataList) {
        return indexMetadataList.stream().map(indexMetadata -> CreateTableSqlBuilder.getIndexSql(name, indexMetadata)).sorted().collect(Collectors.toList());
    }

    public static String getIndexSql(String tableName, IndexMetadata indexMetadata) {
        return StringConnectHelper.newInstance("CREATE{indexType} INDEX \"{indexName}\" ON {tableName} ({columns}) {indexComment};").replace("{indexType}", indexMetadata.getType() == IndexTypeEnum.NORMAL ? "" : " " + indexMetadata.getType().name()).replace("{indexName}", indexMetadata.getName()).replace("{tableName}", tableName).replace("{columns}", () -> {
            List<IndexMetadata.IndexColumnParam> columnParams = indexMetadata.getColumns();
            return columnParams.stream().map(column -> "\"{column}\" {sortMode}".replace("{column}", column.getColumn()).replace("{sortMode}", column.getSort() != null ? column.getSort().name() : "")).collect(Collectors.joining(","));
        }).replace("{indexComment}", StringUtils.hasText(indexMetadata.getComment()) ? "-- " + indexMetadata.getComment() : "").toString();
    }

    private static String getPrimaryKeySql(List<String> primaries) {
        return "PRIMARY KEY ({primaries})".replace("{primaries}", primaries.stream().map(fieldName -> "\"" + fieldName + "\"").collect(Collectors.joining(",")));
    }
}

