/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core.strategy.sqlite.builder;

import lombok.Generated;
import org.dromara.autotable.annotation.enums.DefaultValueEnum;
import org.dromara.autotable.core.strategy.ColumnMetadata;
import org.dromara.autotable.core.strategy.sqlite.data.SqliteTypeHelper;
import org.dromara.autotable.core.utils.StringConnectHelper;
import org.dromara.autotable.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ColumnSqlBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ColumnSqlBuilder.class);

    public static String buildSql(ColumnMetadata columnMetadata, boolean isSinglePrimaryKey, boolean addComma) {
        boolean isAutoIncrement = isSinglePrimaryKey && columnMetadata.isPrimary() && columnMetadata.isAutoIncrement();
        return StringConnectHelper.newInstance("{columnName} {typeAndLength} {null} {default} {primaryKey}{comma}{columnComment}").replace("{columnName}", columnMetadata.getName()).replace("{typeAndLength}", SqliteTypeHelper.getFullType(columnMetadata.getType(), isAutoIncrement)).replace("{null}", columnMetadata.isNotNull() ? "NOT NULL" : "NULL").replace("{default}", () -> {
            DefaultValueEnum defaultValueType = columnMetadata.getDefaultValueType();
            if (defaultValueType == DefaultValueEnum.NULL) {
                return "DEFAULT NULL";
            }
            if (defaultValueType == DefaultValueEnum.EMPTY_STRING) {
                return "DEFAULT ''";
            }
            String defaultValue = columnMetadata.getDefaultValue();
            if (DefaultValueEnum.isCustom((DefaultValueEnum)defaultValueType) && StringUtils.hasText(defaultValue)) {
                return "DEFAULT " + defaultValue;
            }
            return "";
        }).replace("{primaryKey}", () -> {
            if (isAutoIncrement) {
                return "PRIMARY KEY AUTOINCREMENT";
            }
            return "";
        }).replace("{comma}", addComma ? "," : "").replace("{columnComment}", StringUtils.hasText(columnMetadata.getComment()) ? " -- " + columnMetadata.getComment() : "").toString();
    }
}

