/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.autotable.core;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.dromara.autotable.annotation.AutoTable;
import org.dromara.autotable.annotation.Ignore;
import org.dromara.autotable.core.AutoTableAnnotationFinder;
import org.dromara.autotable.core.AutoTableGlobalConfig;

public abstract class AutoTableClassScanner {
    public Set<Class<?>> scan(String[] basePackages) {
        if (basePackages == null) {
            return Collections.emptySet();
        }
        Set<Class<? extends Annotation>> includeAnnotations = this.getIncludeAnnotations();
        Set<Class<? extends Annotation>> excludeAnnotations = this.getExcludeAnnotations();
        AutoTableGlobalConfig.getAutoTableAnnotationInterceptor().intercept(includeAnnotations, excludeAnnotations);
        AutoTableAnnotationFinder autoTableAnnotationFinder = AutoTableGlobalConfig.getAutoTableAnnotationFinder();
        return Arrays.stream(basePackages).map(basePackage -> {
            try {
                return this.getClasses((String)basePackage, clazz -> includeAnnotations.stream().anyMatch(anno -> autoTableAnnotationFinder.exist((Class<?>)clazz, anno)) && excludeAnnotations.stream().noneMatch(anno -> autoTableAnnotationFinder.exist((Class<?>)clazz, anno)));
            }
            catch (IOException | ClassNotFoundException e) {
                throw new RuntimeException(String.format("\u626b\u63cf\u5305%s\u4e0b\u5b9e\u4f53\u51fa\u9519", basePackage), e);
            }
        }).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    protected Set<Class<? extends Annotation>> getExcludeAnnotations() {
        return new HashSet<Class<? extends Annotation>>(Collections.singleton(Ignore.class));
    }

    protected Set<Class<? extends Annotation>> getIncludeAnnotations() {
        return new HashSet<Class<? extends Annotation>>(Collections.singletonList(AutoTable.class));
    }

    protected Set<Class<?>> getClasses(String packageName, Function<Class<?>, Boolean> checker) throws IOException, ClassNotFoundException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        String path = packageName.replace('.', '/');
        String basePackage = path.split("/\\*")[0];
        Pattern checkPattern = Pattern.compile("(" + packageName.replace(".", "\\/").replace("**", "[A-Za-z0-9$_/]+").replace("*", "[A-Za-z0-9$_]+") + "[A-Za-z0-9$_/]+)\\.class$");
        Enumeration<URL> resources = classLoader.getResources(basePackage);
        HashSet classes = new HashSet();
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            if ("file".equals(resource.getProtocol())) {
                String decodedPath = URLDecoder.decode(resource.getFile(), "UTF-8");
                classes.addAll(this.findLocalClasses(checkPattern, new File(decodedPath), checker));
                continue;
            }
            if (!"jar".equals(resource.getProtocol())) continue;
            JarURLConnection jarURLConnection = (JarURLConnection)resource.openConnection();
            classes.addAll(this.findJarClasses(checkPattern, jarURLConnection.getJarFile(), checker));
        }
        return classes;
    }

    protected Set<Class<?>> findLocalClasses(Pattern checkPattern, File directory, Function<Class<?>, Boolean> checker) throws ClassNotFoundException, IOException {
        HashSet classes = new HashSet();
        if (!directory.exists()) {
            return classes;
        }
        Files.walk(directory.toPath(), new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(".class")).forEach(path -> {
            try {
                String className;
                Class<?> clazz;
                String pathUrl = path.toUri().toURL().toString();
                Matcher matcher = checkPattern.matcher(pathUrl);
                if (matcher.find() && ((Boolean)checker.apply(clazz = Class.forName(className = matcher.group(1).replace("/", ".")))).booleanValue()) {
                    classes.add(clazz);
                }
            }
            catch (ClassNotFoundException | MalformedURLException exception) {
                // empty catch block
            }
        });
        return classes;
    }

    protected Set<Class<?>> findJarClasses(Pattern checkPattern, JarFile jarFile, Function<Class<?>, Boolean> checker) throws ClassNotFoundException {
        HashSet classes = new HashSet();
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            Class<?> clazz;
            Matcher matcher;
            JarEntry entry = entries.nextElement();
            if (!entry.getName().endsWith(".class") || !(matcher = checkPattern.matcher(entry.getName())).find()) continue;
            String className = matcher.group(1).replace("/", ".");
            try {
                clazz = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                clazz = Thread.currentThread().getContextClassLoader().loadClass(className);
            }
            if (clazz == null || !checker.apply(clazz).booleanValue()) continue;
            classes.add(clazz);
        }
        return classes;
    }
}

